//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGL.h
 * @brief		gl g֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGL_H_
#define INCG_IRIS_GXGL_H_

//======================================================================
// include
#include "gxgl_inchead.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

//======================================================================
// define
#define GXGL_MATRIX_PROJECTION		(0)
#define GXGL_MATRIX_VIEW			(1)
#define GXGL_MATRIX_WORLD			(2)
#define GXGL_MATRIX_TEXTURE			(3)

#define GXGL_TEXTURE_SHIFT(n)		((n) << 0)
#define GXGL_TEXTURE_BYTE			GXGL_TEXTURE_SHIFT(1)
#define GXGL_TEXTURE_SHORT			GXGL_TEXTURE_SHIFT(2)
#define GXGL_TEXTURE_FLOAT			GXGL_TEXTURE_SHIFT(3)
#define GXGL_TEXTURE_BITS			GXGL_TEXTURE_SHIFT(3)
#define GXGL_GET_TEXTURE_BITS(n)	(((n) & GXGL_TEXTURE_BITS) >> 0)

#define GXGL_COLOR_SHIFT(n)			((n) << 2)
#define GXGL_COLOR_RGB_BYTE			GXGL_COLOR_SHIFT(1)
#define GXGL_COLOR_RGB_SHORT		GXGL_COLOR_SHIFT(2)
#define GXGL_COLOR_RGB_FLOAT		GXGL_COLOR_SHIFT(3)
#define GXGL_COLOR_RGBA_BYTE		GXGL_COLOR_SHIFT(4)
#define GXGL_COLOR_RGBA_SHORT		GXGL_COLOR_SHIFT(5)
#define GXGL_COLOR_RGBA_FLOAT		GXGL_COLOR_SHIFT(6)
#define GXGL_COLOR_FIXED			GXGL_COLOR_SHIFT(7)
#define GXGL_COLOR_BITS				GXGL_COLOR_SHIFT(7)
#define GXGL_GET_COLOR_BITS(n)		(((n) & GXGL_COLOR_BITS) >> 2)

#define GXGL_NORMAL_SHIFT(n)		((n) << 5)
#define GXGL_NORMAL_BYTE			GXGL_NORMAL_SHIFT(1)
#define GXGL_NORMAL_SHORT			GXGL_NORMAL_SHIFT(2)
#define GXGL_NORMAL_FLOAT			GXGL_NORMAL_SHIFT(3)
#define GXGL_NORMAL_BITS			GXGL_NORMAL_SHIFT(3)
#define GXGL_GET_NORMAL_BITS(n)		(((n) & GXGL_NORMAL_BITS) >> 5)

#define GXGL_VERTEX_SHIFT(n)			((n) << 7)
#define GXGL_VERTEX_BYTE				GXGL_VERTEX_SHIFT(1)
#define GXGL_VERTEX_SHORT				GXGL_VERTEX_SHIFT(2)
#define GXGL_VERTEX_FLOAT				GXGL_VERTEX_SHIFT(3)
#define GXGL_VERTEX_BITS				GXGL_VERTEX_SHIFT(3)
#define GXGL_GET_VERTEX_BITS(n)			(((n) & GXGL_VERTEX_BITS) >> 7)

#define GXGL_VERTEX_SIZE_SHIFT(n)		((n) << 9)
#define GXGL_VERTEX_XYZ					GXGL_VERTEX_SIZE_SHIFT(0)
#define GXGL_VERTEX_XY					GXGL_VERTEX_SIZE_SHIFT(1)
#define GXGL_VERTEX_X					GXGL_VERTEX_SIZE_SHIFT(2)
#define GXGL_VERTEX_XYZW				GXGL_VERTEX_SIZE_SHIFT(3)
#define GXGL_VERTEX_SIZE_BITS			GXGL_VERTEX_SIZE_SHIFT(3)
#define GXGL_GET_VERTEX_SIZE_BITS(n)	(((n) & GXGL_VERTEX_SIZE_BITS) >> 9)

#define GXGL_TRANSFORM_SHIFT(n)			((n) << 23)
#define GXGL_TRANSFORM_3D				GXGL_TRANSFORM_SHIFT(0)
#define GXGL_TRANSFORM_2D				GXGL_TRANSFORM_SHIFT(1)
#define GXGL_TRANSFORM_BITS				GXGL_TRANSFORM_SHIFT(1)
#define GXGL_GET_TRANSFORM_BITS(n)		(((n) & GXGL_TRANSFORM_BITS) >> 23)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
// 擾
void*		gxglGetMemory(int nSize);
// Start
void		gxglStart(void* pList, int nSize);
// Finish
int			gxglFinish(void);
// Begin
void		gxglBegin(GLenum mode);
// End
void		gxglEnd(void);
// ClearColor
void		gxglClearColor(GLuint color);
// DrawArray
void		gxglDrawArray(GLenum nPrim, GLuint nVtype, int nCount, const void* pIndices, const void* pVertices);
// DrawArrayN
void		gxglDrawArrayN(GLenum nPrim, GLuint nVtype, int nCount, int nPrimCount, const void* pIndices, const void* pVertices);
// Viewport
void		gxglViewport(int x, int y, int width, int height);
// 3d matrix load
void		gxglLoad3DMatrix(void);
// 3d matrix unload
void		gxglUnload3DMatrix(void);
// 2d matrix load
void		gxglLoad2DMatrix(void);
// 2d matrix unload
void		gxglUnload2DMatrix(void);
// set matrix
void		gxglSetMatrix(int type, const f32* mtx);
// perspective
void		gxglMatrixPerspectiveFov(IrisFMtx44* mtx, f32 fovy, f32 aspect, f32 r_near, f32 r_far);
// view matrix create
IrisFMtx44*	gxglMatrixLookAt(IrisFMtx44* mtx, const IrisFVec4* eye, const IrisFVec4* center, const IrisFVec4* up);

// error check
bool		gxglCheckError(void);
// error code ̎擾
LPCTSTR		gxglGetErrorString (GLenum error);
LPCSTR		gxglGetErrorStringA(GLenum error);
LPCWSTR		gxglGetErrorStringW(GLenum error);

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
