//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLSystem.cpp
 * @brief		gl NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLSystem_CPP_

//======================================================================
// include
#include "GXGLSystem.h"
#include "GXGLError.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// variable
// gl instance
static COpenGL	s_gl;

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
COpenGL::COpenGL(void)
: m_pDisplayList(nullptr)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
COpenGL::~COpenGL(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in] param	= p[^
 * @return	
*//***********************************************************************/
bool COpenGL::Initialize(LPINIT_PARAM param)
{
    gxglutInitDisplayMode( GXGLUT_RGBA | GXGLUT_DOUBLE );
	gxglutInitWindowPosition(param->x, param->y);
	gxglutInitWindowSize( param->width, param->height );
    gxglutCreateWindow( "COpenGL" );

	Viewport(0, 0, param->width, param->height);
	return true;
}

/**********************************************************************//**
 *
 * DisplayListobt@̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in] pList	= obt@
 * @param [in] size		= obt@TCY
*//***********************************************************************/
void COpenGL::SetDisplayListBuffer(void* pList, u32 size)
{
	m_pDisplayList = pList;
	m_Size = size;
}

/**********************************************************************//**
 *
 * 擾
 *
 -----------------------------------------------------------------------
 * @return
*//***********************************************************************/
void* COpenGL::GetMemory(int nSize)
{
	return gxglGetMemory(nSize);
}

/**********************************************************************//**
 *
 * Jn
 *
*//***********************************************************************/
void COpenGL::Start(void)
{
	gxglStart(m_pDisplayList, m_Size);
}

/**********************************************************************//**
 *
 * I
 *
 -----------------------------------------------------------------------
 * @return
*//***********************************************************************/
int COpenGL::Finish(void)
{
	return gxglFinish();
}

/**********************************************************************//**
 *
 * SwapBuffers
 *
*//***********************************************************************/
void COpenGL::SwapBuffers(void)
{
	gxglutSwapBuffers();
}

/**********************************************************************//**
 *
 * Viewport
 *
 ----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	width	= 
 * @param [in]	height	= 
*//***********************************************************************/
void COpenGL::Viewport(int x, int y, int width, int height)
{
	gxglViewport(x, y, width, height);
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../fnd/image/FndTga.h"
#include "../../fnd/image/FndPng.h"
#include "GXGLTexture.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// declare
static void displayFunc1(void);
static void displayFunc2(void);

#if defined(_IRIS_SUPPORT_PNG)
#  define TEST_PNG
#endif

//======================================================================
// class
class CGXGLSystemUnitTest : public iris::unit::CUnitTest<CGXGLSystemUnitTest>
{
public:
	CGLTexture	m_tex;

	// function
	template<typename TN>
	void test_base(PFN_GXGLUTDisplayFunc cb, TN& img, LPCTSTR path)
	{
		COpenGL& gl = COpenGL::GetInstance();
		CGLTexture& tex = m_tex;

		TCHAR path2[MAX_PATH];
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
		std::cout << "Jt@C͂ĂB" << std::endl;
		std::tcin >> path2;
		path = path2;
#endif

		if( !img.ReadFile(path) )
		{
			_tprintf(path);
			_tprintf(IRIS_TEXT("\n"));
			std::cout << "t@CI[vɎs܂B" << std::endl;
			return;
		}
		std::cout << "file open" << std::endl;

		static const u32 buf_size = 4*1024*1024;	// 4KB
		void* buf = new u8 [buf_size];
		gx::gl::COpenGL::INIT_PARAM param;
		param.x = 100;
		param.y = 100;
		param.width = img.GetWidth();
		param.height = img.GetHeight();

		gl.Initialize(&param);
		gl.SetDisplayListBuffer(buf, buf_size);

		gl.ClearColor(0xFFFF2222);

		{
			void* data = new u32 [img.GetWidth() * img.GetHeight()];
			if( img.CreateImage(data, CTga::PF_RGBA8) )
			{
				if( !tex.Create() ) return;
				tex.Bind();
				tex.Parameteri(GL_TEXTURE_MAG_FILTER, GL_NEAREST);
				tex.Parameteri(GL_TEXTURE_MIN_FILTER, GL_NEAREST);
				GXGL_ERROR(gl.GetError());
				tex.Image2D(0, 4, 512, 512, 0
					, GL_RGBA, GL_UNSIGNED_BYTE, nullptr);
				tex.SubImage2D(0, 0, 0, img.GetWidth(), img.GetHeight()
					, GL_RGBA, GL_UNSIGNED_BYTE, data);
				GXGL_ERROR(gl.GetError());
			}
			delete [] data;
		}

		gxglutSetWindowTitle("GXGLSystemUnitTest");

		gxglutDisplayFunc( cb );

#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
		gxglutDestroyWindow(gxglutGetWindow());
#else
		gxglutMainLoop();
#endif

		delete [] buf;
	}
};

//======================================================================
// test
#ifdef _IRIS_SUPPORT_PNG
IRIS_UNITTEST_F(CGXGLSystemUnitTest, Png)
{
	CPng img;
	TCHAR path[MAX_PATH] = TEXT("../../../data/image/sample.png");
	test_base(displayFunc1, img, path);
}
#endif
IRIS_UNITTEST_F(CGXGLSystemUnitTest, Tga)
{
	CTga img;
	TCHAR path[MAX_PATH] = TEXT("../../../data/image/sample.tga");
	test_base(displayFunc1, img, path);
}
IRIS_UNITTEST_F(CGXGLSystemUnitTest, Inv)
{
#ifdef TEST_PNG
	CPng img;
	TCHAR path[MAX_PATH] = TEXT("../../../data/image/sample.png");
#else
	CTga img;
	TCHAR path[MAX_PATH] = TEXT("../../../data/image/sample.tga");
#endif
	test_base(displayFunc2, img, path);
}

void displayFunc1(void)
{
	CGXGLSystemUnitTest* ut = CGXGLSystemUnitTest::GetCurrent();
	COpenGL& gl = COpenGL::GetInstance();
	CGLTexture& tex = ut->m_tex;

	gl.Clear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);

	gl.Start();

	{
		// eNX`on
		gl.Enable(GL_TEXTURE_2D);
		gl.Enable(GL_ALPHA_TEST);

		tex.Draw2D();

		// eNX`off
		gl.Disable(GL_TEXTURE_2D);
	}

	gl.Finish();

	gl.SwapBuffers();
}

void displayFunc2(void)
{
	CGXGLSystemUnitTest* ut = CGXGLSystemUnitTest::GetCurrent();
	COpenGL& gl = COpenGL::GetInstance();
	CGLTexture& tex = ut->m_tex;

	gl.Clear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);

	gl.Start();

	{
		// eNX`on
		gl.Enable(GL_TEXTURE_2D);
		gl.Enable(GL_ALPHA_TEST);

		tex.Draw2D();

		// eNX`off
		gl.Disable(GL_TEXTURE_2D);
#if 1
		// uhon
		gl.Enable(GL_BLEND);
		// ]
		gl.BlendFunc(GL_ONE_MINUS_DST_COLOR, GL_ZERO);
		tex.Draw2D();
		gl.Disable(GL_BLEND);
#endif
	}

	gl.Finish();

	gl.SwapBuffers();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
