//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLProgram.cpp
 * @brief		GLSL VF[_[vOIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLProgram_CPP_

//======================================================================
// include
#include "GXGLProgram.h"

#if		defined(_IRIS_SUPPORT_OPENGL)

//======================================================================
// const
namespace {
	static const int LOG_BUFFER_LENGTH = 1024;	// Oo͗pobt@TCY
}

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGLProgram::CGLProgram(void)
: m_Program(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGLProgram::~CGLProgram(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * IuWFNg̍쐬
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CGLProgram::Create(void)
{
	if( glCreateProgram == nullptr ) return false;
	m_Program = glCreateProgram();
	if( m_Program == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
*//***********************************************************************/
void CGLProgram::Delete(void)
{
	if( m_Program == 0 ) return;
	if( IsActive() ) UseFixedFunction();
	glDeleteProgram(m_Program);
	m_Program = 0;
}

/**********************************************************************//**
 *
 * vO̎gp
 *
*//***********************************************************************/
void CGLProgram::UseProgram(void)
{
	IRIS_ASSERT( m_Program != 0 );
	glUseProgram(m_Program);
}

/**********************************************************************//**
 *
 * Œ@\pCvC̎gp
 *
*//***********************************************************************/
void CGLProgram::UseFixedFunction(void)
{
	glUseProgram(0);
}

/**********************************************************************//**
 *
 * vO̎gpݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	bUse	= gp邩ǂ
*//***********************************************************************/
void CGLProgram::Activate(bool bUse)
{
	IRIS_ASSERT( m_Program != 0 || !bUse );
	GLuint prog = m_Program;
	if( !bUse ) prog = 0;
	glUseProgram(m_Program);
}

/**********************************************************************//**
 *
 * vOgpǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CGLProgram::IsActive(void) const
{
	if( m_Program == 0 ) return false;
	GLuint prog;
	glGetIntegerv(GL_CURRENT_PROGRAM, pointer_cast<GLint*>(&prog));
	if( prog != m_Program ) return false;
	return true;
}

/**********************************************************************//**
 *
 * VF[_[IuWFNg̓o^
 *
 -----------------------------------------------------------------------
 * @param [in]	uShader	= VF[_[IuWFNg
*//***********************************************************************/
void CGLProgram::Attach(GLuint uShader)
{
	IRIS_ASSERT( m_Program != 0 );
	glAttachShader(m_Program, uShader);
}

/**********************************************************************//**
 *
 * VF[_[IuWFNg̓o^
 *
 -----------------------------------------------------------------------
 * @param [in]	uShader	= VF[_[IuWFNg
*//***********************************************************************/
void CGLProgram::Detach(GLuint uShader)
{
	IRIS_ASSERT( m_Program != 0 );
	glDetachShader(m_Program, uShader);
}

/**********************************************************************//**
 *
 * vÕN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CGLProgram::Link(void)
{
	GLint linked = 0;
	if( m_Program == 0 ) return false;
	// N
	glLinkProgram(m_Program);
	getiv(GL_LINK_STATUS, &linked);
#ifdef _IRIS_DEBUG
	char log[LOG_BUFFER_LENGTH];
	GetInfoLog(log, LOG_BUFFER_LENGTH);
	dprintfA("Program Info Log\n%s\n", log);
#endif
	if( !linked )	return false;
	return true;
}

/**********************************************************************//**
 *
 * O̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pString	= o̓obt@
 * @param [in]	nSize	= o̓obt@TCY
 * @return	񂾃TCYipStringnullptrnꍇ́AKvȃTCYj
*//***********************************************************************/
GLsizei CGLProgram::GetInfoLog(LPSTR pString, GLsizei nSize) const
{
	GLsizei written = 0;
	if( pString == nullptr )
	{
		getiv(GL_INFO_LOG_LENGTH, &written);
		return written;
	}
	glGetProgramInfoLog(m_Program, nSize, &written, pString);
	return written;
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif
