//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLSL.cpp
 * @brief		GLSL NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLSL_CPP_

//======================================================================
// include
#include "GXGLSL.h"

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
/**********************************************************************//**
 *
 * glsl̏
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool gxglslInit(void)
{
#if	defined(_IRIS_SUPPORT_OPENGL)
	// glewgp܂
	return gxglewInit();
#else
	return false;
#endif
}

/**********************************************************************//**
 *
 * VF[_[T|[gĂ邩ǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool gxglslIsSupport(void)
{
#if	defined(_IRIS_SUPPORT_OPENGL) && defined(_IRIS_SUPPORT_GLEW)
	if( !GLEW_ARB_shader_objects
		|| !GLEW_ARB_fragment_shader
		|| !GLEW_ARB_vertex_shader
		)	return false;
	return true;
#else
	return false;
#endif
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_OPENGL)
#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../ut/GXGLUT.h"
#include "GXGLShader.h"
#include "GXGLProgram.h"
#include "../../../iris_using.h"
#include "../../../iris_global.h"

//======================================================================
// test
IRIS_UNITTEST(CGXGLSLUnitTest, Func)
{
	if( !gxglslIsSupport() ) return;
#ifdef UNICODE
	int argc = 0;
	gxglutInit(&argc, nullptr);
#else
	int argc = irisGetArgc();
	gxglutInit(&argc, irisGetArgv());
#endif
    gxglutInitDisplayMode(GXGLUT_RGBA | GXGLUT_DOUBLE);
	gxglutInitWindowPosition(100, 100);
	gxglutInitWindowSize( 256, 256 );
    gxglutCreateWindow( "GXGLSLUnitTest" );
	if( !gxglewInit() ) return;

	CGLShader vtxsh;
	CGLProgram prog;
	if( !vtxsh.Create(GL_VERTEX_SHADER) ) return;
	if( !vtxsh.Load("sample.vs") ) return;
	if( !vtxsh.Compile() ) return;

	if( !prog.Create() ) return;
	prog.Attach(vtxsh());

	vtxsh.Delete();

	prog.Link();

	gxglutMainLoop();

}

#endif
#endif
