//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLUTApp.h
 * @brief		GLUT AvP[VNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLUTApp_H_
#define INCG_IRIS_GXGLUTApp_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../../../fnd/container/FndSingleton.h"
#include "GXGLUT.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/**
 * @brief	GLUT App NX
*/
class CGLUTApp : public IIrisObject
{
private:
	int		m_Window;	//!< EBhEnh
public:
	// RXgN^
	CGLUTApp(void);
	// fXgN^
	virtual ~CGLUTApp(void);

public:
	// 
	bool	Initialize(int* argcp, char** argv, u32 displayMode);
	// EBhE쐬
	bool	Create(int x, int y, int w, int h, LPCSTR title);
	// EBhEj
	void	Destroy(void);
	// s
	void	Run(void);

protected:
	// Cxg֐
	virtual	bool	OnInit(void)					{ return true; }
	virtual	void	OnDisplay(void)					{}
	virtual void	OnReshape(int /*w*/, int /*h*/)	{}
	virtual void	OnIdle(void)					{}
	virtual	void	OnExit(void)					{}

private:
	static	void	GXGLUTCALLBACK	_DisplayFunc(void);
	static	void	GXGLUTCALLBACK	_ReshapeFunc(int width, int height);
	static	void	GXGLUTCALLBACK	_IdleFunc(void);
	static	void	GXGLUTCALLBACK	_ExitFunc(void);
};

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
