//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_config.h
 * @brief		configt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_config_H_
#define INCG_IRIS_iris_config_H_

//======================================================================
// include
#include "iris_limits.h"

//======================================================================
// define
// DEBUG
//#if defined(_DEBUG) && !defined(_IRIS_DEBUG)
//#  define _IRIS_DEBUG	1
//#elif defined(NDEBUG) && defined(_IRIS_DEBUG)
//#  undef _IRIS_DEBUG
//#endif

//--------------------
// 32bit or 64bit
#if		defined(_WIN32)
#  if	defined(_WIN64)
#    define _IRIS64		1
#  else
#    define _IRIS32		1
#  endif
#else
#  define _IRIS32		1
#endif

//--------------------
// float
#ifndef __FLOAT_SIZE__
#  define __FLOAT_SIZE__	4
#endif

//--------------------
// double
#ifndef __DOUBLE_SIZE__
#  define __DOUBLE_SIZE__	8
#endif

//--------------------
// 128bitϐ
#if		defined(IRIS_INTEGRAL_MAX_BITS)	&& (IRIS_INTEGRAL_MAX_BITS >= 128)
#  define _IRIS_SUPPORT_INT128
#endif

//--------------------
// sse, sse2ւ̑Ή
#if		defined(_WIN32)
#  if	(defined(_M_IX86_FP) && (_M_IX86_FP == 1))	// sse
#    define _IRIS_SUPPOTR_SSE
#  elif	(defined(_M_IX86_FP) && (_M_IX86_FP == 2)) || defined(_M_X64) // sse2
#    define _IRIS_SUPPOTR_SSE2
#  endif
#endif

#ifndef _IRIS_SUPPOTR_SSE2
#  if	defined(__SSE2__) && (!defined(__GNUC__) || IRIS_GNUC_AT_LEAST(4, 2))
#    define _IRIS_SUPPOTR_SSE2
#  endif
#endif

//--------------------
// ^CCu
#if		defined(_WIN32)
#  if		defined(_MT)
#    if			defined(_DLL)
#      define	_IRIS_MD
#    else
#      define	_IRIS_MT
#    endif
#  endif
#endif

//--------------------
// GL
#if	(defined(IRIS_WIN32) && !defined(IRIS_WIN32_WCE)) || defined(IRIS_APPLE)
#  define	_IRIS_SUPPORT_OPENGL
#else
#endif

//--------------------
// static or dynamic library
#define IRIS_UNKOWN_LIB		0x00		// wȂiftHgj
#define IRIS_DEFAULT_LIB	0			// wȂiftHgj
#define IRIS_STATIC_LIB		0x10		// static library  link
#define IRIS_DYNAMIC_LIB	0x11		// dynamic library  link

//--------------------
// sR[h
#ifndef __CR
#  define __CR		"\r"
#endif
#ifndef __LF
#  define __LF		"\n"
#endif
#ifndef __CRLF
#  define __CRLF	"\r\n"
#endif
#ifndef __NL
#  define __NL		__CRLF
#endif

//
#if		defined(_WIN32) && defined(_MT)
#  if		defined(_DLL)
#    define IRIS_LIB_MODE		"md"
#  else
#    define IRIS_LIB_MODE		"mt"
#  endif
#  if		IRIS_MSC_AT_LEAST(1600)	//_MSC_VER_VC10
#    define IRIS_LIB_VCVER		"2010"
#  elif		IRIS_MSC_AT_LEAST(1500)	//_MSC_VER_VC9
#    define IRIS_LIB_VCVER		"2008"
#  else
#    define IRIS_LIB_VCVER		"2005"
#  endif
#  if		defined(_WIN64)
#    define IRIS_LIB_AMD64		"_amd64"
#  else
#    define IRIS_LIB_AMD64
#  endif
#  if		defined(_WIN64)
#    define IRIS_LIB_X64		"_x64"
#  else
#    define IRIS_LIB_X64
#  endif
#endif

#if		defined(_DEBUG)
#  define	IRIS_LIB_POSTFIX	"d"
#else
#  define	IRIS_LIB_POSTFIX
#endif


// ݒ
//IRIS_MSC_PRAGMA_WARNING_DISABLE(4100)	// gpϐ
IRIS_MSC_PRAGMA_WARNING_DISABLE(4061)	// switch ̗񋓎q 'hoge'  case xɂĖIɃnh܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4121)	// õACg͉ߏɃpbLOĂ܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4127)	// 萔łB
IRIS_MSC_PRAGMA_WARNING_DISABLE(4201)	// W̊g@\ F \
IRIS_MSC_PRAGMA_WARNING_DISABLE(4214)	// W̊g@\ F ^ȊÕrbgtB[hłB
IRIS_MSC_PRAGMA_WARNING_DISABLE(4238)	// W̊g@\ F EӒl̃NXӒlɎgp܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4239)	// W̊g@\ F 'hoge'  'hoge&' ւ̕ϊłB
IRIS_MSC_PRAGMA_WARNING_DISABLE(4505)	// QƂĂȂ[J֐͍폜܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4917)	// GUID ̓NXAC^[tFCX܂͖OԂ݂̂Ɋ֘At邱Ƃł܂B

#endif
