//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_const.h
 * @brief		iris const wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_const_H_
#define INCG_IRIS_iris_const_H_

//======================================================================
// include
#include "iris_stdint.h"

//======================================================================
// macros
#define MATH_F64_E			2.7182818284590452354		//!< e
#define MATH_F64_LOG2E		1.4426950408889634074		//!< log2(e)
#define MATH_F64_LOG10E		0.43429448190325182765		//!< log10(e)
#define MATH_F64_LN2		0.69314718055994530942		//!< ln(2)
#define MATH_F64_LN10		2.30258509299404568402		//!< ln(10)
#define MATH_F64_PI			3.14159265358979323846		//!< pi
#define MATH_F64_2PI		(MATH_F64_PI * 2.0)			//!< 2 * pi
#define MATH_F64_PI_2		1.57079632679489661923		//!< pi / 2
#define MATH_F64_PI_4		0.78539816339744830962		//!< pi / 4
#define MATH_F64_3PI_4		2.3561944901923448370E0		//!< 3 * pi / 4
#define MATH_F64_SQRTPI		1.77245385090551602792981	//!< squrt(pi)
#define MATH_F64_1_PI		0.31830988618379067154		//!< 1 / pi
#define MATH_F64_2_PI		0.63661977236758134308		//!< 2 / pi
#define MATH_F64_2_SQRTPI	1.12837916709551257390		//!< 2 / squrt(pi)
#define MATH_F64_SQRT2		1.41421356237309504880		//!< squrt(2)
#define MATH_F64_1_SQRT2	0.70710678118654752440		//!< 1 / squrt(2)
#define MATH_F64_SQRT3		1.73205080756887729353		//!< squrt(3)
#define MATH_F64_SQRT3_2	0.86602540378443864676		//!< squrt(3) / 2

#define MATH_F64_IVLN10		0.43429448190325182765		//!< 1 / log(10)
#define MATH_F64_INVLN2		1.4426950408889633870E0		//!< 1 / log(2)
#define MATH_F64_LOG10N2	0.30102999566398119521		//!< log10(2)
#define MATH_F64_LOG2N10	3.32192809488736234787		//!< log2(10)

#define MATH_F64_EPSIRON	0.00001						//!< 

// f32 macros
#define MATH_F32_P_INF_BITS			(0x7F800000L)	//!< +
#define MATH_F32_N_INF_BITS			(0xFF800000L)	//!< -
#define MATH_F32_P_NAN_BITS			(0x7F800001L)	//!< +NaN
#define MATH_F32_N_NAN_BITS			(0xFF800001L)	//!< -NaN
#define MATH_F32_P_QNAN_BITS		(0x7FC00000L)	//!< +QNaN
#define MATH_F32_N_QNAN_BITS		(0xFFC00000L)	//!< -QNaN
#define MATH_F32_P_SNAN_BITS(s)		( (0x7F800000L) | ((s) & 0x003FFFFF) )	//!< +SNaN
#define MATH_F32_N_SNAN_BITS(s)		( (0xFF800000L) | ((s) & 0x003FFFFF) )	//!< -SNaN

#define MATH_F32_E			F32_C(MATH_F64_E)			//!< e
#define MATH_F32_LOG2E		F32_C(MATH_F64_LOG2E)		//!< log2(e)
#define MATH_F32_LOG10E		F32_C(MATH_F64_LOG10E)		//!< log10(e)
#define MATH_F32_LN2		F32_C(MATH_F64_LN2)			//!< ln(2)
#define MATH_F32_LN10		F32_C(MATH_F64_LN10)		//!< ln(10)
#define MATH_F32_PI			F32_C(MATH_F64_PI)			//!< pi
#define MATH_F32_2PI		(MATH_F32_PI * 2.0f)		//!< 2 * pi
#define MATH_F32_PI_2		F32_C(MATH_F64_PI_2)		//!< pi / 2
#define MATH_F32_PI_4		F32_C(MATH_F64_PI_4)		//!< pi / 4
#define MATH_F32_3PI_4		F32_C(MATH_F64_3PI_4)		//!< 3 * pi / 4
#define MATH_F32_SQRTPI		F32_C(MATH_F64_SQRTPI)		//!< squrt(pi)
#define MATH_F32_1_PI		F32_C(MATH_F64_1_PI)		//!< 1 / pi
#define MATH_F32_2_PI		F32_C(MATH_F64_2_PI)		//!< 2 / pi
#define MATH_F32_2_SQRTPI	F32_C(MATH_F64_2_SQRTPI)	//!< 2 / squrt(pi)
#define MATH_F32_SQRT2		F32_C(MATH_F64_SQRT2)		//!< squrt(2)
#define MATH_F32_1_SQRT2	F32_C(MATH_F64_1_SQRT2)		//!< 1 / squrt(2)
#define MATH_F32_SQRT3		F32_C(MATH_F64_SQRT3)		//!< squrt(3)
#define MATH_F32_SQRT3_2	F32_C(MATH_F64_SQRT3_2)		//!< squrt(3) / 2

#define MATH_F32_IVLN10		F32_C(MATH_F64_IVLN10)		//!< 1 / log(10)
#define MATH_F32_INVLN2		F32_C(MATH_F64_INVLN2)		//!< 1 / log(2)
#define MATH_F32_LOG10N2	F32_C(MATH_F64_LOG10N2)		//!< log10(2)
#define MATH_F32_LOG2N10	F32_C(MATH_F64_LOG2N10)		//!< log2(10)

#define MATH_F32_EPSIRON	F32_C(MATH_F64_EPSIRON)		//!< 

//======================================================================
// static const
#if	defined(__cplusplus)

namespace iris {
}	// end of namespace iris

#endif

#endif
