//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_debug.h
 * @brief		fobOp`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_debug_H_
#define INCG_IRIS_iris_debug_H_

//======================================================================
// include
#include "iris_inchead.h"

IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4255)
#include <stdio.h>
IRIS_MSC_PRAGMA_WARNING_END()

#include "c++0x/cpp0x_static_assert.h"

//======================================================================
// define
// logo
#ifndef dprintfA
#  ifdef _IRIS_DEBUG	// DEBUG
#    define	dprintfA				printf
#  else
#    if	IRIS_STDC_VA_ARGS
#      define	dprintfA(...)		(void)(0)
#    else
#      define	dprintfA			NOP_VA_ARGS
#    endif
#  endif
#endif

#ifndef dprintfW
#  ifdef _IRIS_DEBUG	// DEBUG
#    if		defined(IRIS_WCS)
#      define	dprintfW			wprintf
#    else
#      define	dprintfW			printf
#    endif
#  else
#    if		IRIS_STDC_VA_ARGS
#      define	dprintfW(...)		(void)(0)
#    else
#      define	dprintfW			NOP_VA_ARGS
#    endif
#  endif
#endif

#ifdef UNICODE
#define	dprintf				dprintfW
#else
#define	dprintf				dprintfA
#endif

#ifndef OutputDebugString
#  define OutputDebugString	dprintf
#endif
#ifndef dbgoutputA
#  ifdef	_WIN32
#    define dbgoutputA		OutputDebugStringExA
#  else
#    define dbgoutputA		dprintfA
#  endif
#endif
#ifndef dbgoutputW
#  ifdef	_WIN32
#    define dbgoutputW		OutputDebugStringExW
#  else
#    define dbgoutputW		dprintfW
#  endif
#endif
#ifdef UNICODE
#  define	dbgoutput			dbgoutputW
#else
#  define	dbgoutput			dbgoutputA
#endif


// ^Ul̏o
#define dprintf_bool(fmt, b)	dprintf(fmt IRIS_TEXT(": %s") IRIS_TEXT(__NL), b ? IRIS_TEXT("TRUE") : IRIS_TEXT("FALSE"))


#ifdef _IRIS_DEBUGTEST_ENABLE
#  define dtprintf			dprintf
#else
#  if	IRIS_STDC_VA_ARGS
#    define dtprintf(...)		(void)(0)
#  else
#    define dtprintf			NOP_VA_ARGS
#  endif
#endif

// fobOtO
#ifdef _IRIS_DEBUG

// ASSERT ֌Wiׂ͂āA}`oCgj
#ifndef IRIS_OS_ASSERT
#if		defined(IRIS_WIN32)	// for WIN32
#  include <assert.h>
#  define IRIS_OS_ASSERT(exp)			assert(exp)
#elif	defined(IRIS_AARM)
#  ifndef STM32_LED_ASSERT
#    define STM32_LED_ASSERT(exp)		do { (void)(exp); } while(1)
#  endif
#  define IRIS_OS_ASSERT(exp)			STM32_LED_ASSERT(exp);
#else
#  define IRIS_OS_ASSERT(exp)			do { (void)(exp); } while(1)
#endif
#endif

/// ASSERT
#define IRIS_ASSERT(exp)			do { if( !(exp) ) { dprintfA("*** ASSERT: " __FILE__ "(%d) %s : <%s>" __NL, __LINE__, __func__, #exp ); IRIS_OS_ASSERT(exp); } } while(0)
#define IRIS_ASSERTMSG(exp, msg)	do { if( !(exp) ) { dprintfA("*** ASSERT: " __FILE__ "(%d) %s : <%s>" __NL ">>> %s" __NL, __LINE__, __func__, #exp, msg ); IRIS_OS_ASSERT(exp); } } while(0)
#define IRIS_ASSERT_BREAK(exp)		do { if( !(exp) ) { dprintfA("*** ASSERT: " __FILE__ "(%d) %s : <%s>" __NL, __LINE__, __func__, #exp ); IRIS_SetBreakPoint(); IRIS_OS_ASSERT(exp); } } while(0)

/// xo
#define IRIS_WARNING(str)			dprintfA( "*** WARNING: " __FILE__ "(%d) %s : <%s>" __NL, __LINE__, __func__, str )
#define IRIS_ERRORWARNING(err, str)	dprintfA( "*** WARNING: " __FILE__ "(%d) %s : error <%d> (%s)" __NL, __LINE__, __func__, err, str )
/// VERIFY
#define	IRIS_VERIFY(exp)			IRIS_ASSERT(exp)
/// VERIFY and RETURN
#define IRIS_VERIFYRETURN(exp, ret)	do { IRIS_ASSERT(exp); if( !(exp) ) return ret; } while(0)
#define IRIS_VERIFYTHROW(exp)		do { if( !(exp) ) throw #exp; } while(0)
/// EXPECT
#define IRIS_EXPECT_TRUE(exp)		do { if( !(exp) ) IRIS_WARNING(#exp); } while(0)
/// Oo
#define IRIS_LOG(str)				dprintfA( "*** LOG: " __FILE__ "(%d) %s : <%s>" __NL, __LINE__, __func__, str )
/// fobOo
#define IRIS_OUTPUTDEBUGSTRING(str)	dbgoutput(str)

#else	// not _IRIS_DEBUG

#define IRIS_WARNING(str)			(void)(0)
#define IRIS_ERRORWARNING(err, str)	(void)(0)
#define IRIS_ASSERT(exp)			(void)(0)
#define IRIS_ASSERTMSG(exp, msg)	(void)(0)
#define IRIS_VERIFY(exp)			(void)(exp)
#define IRIS_VERIFYRETURN(exp, ret)	if( !(exp) ) return ret
#define IRIS_VERIFYTHROW(exp)		if( !(exp) ) throw #exp
#define IRIS_EXPECT_TRUE(exp)		(void)(exp)
#define IRIS_LOG(str)				(void)(0)
#define IRIS_OUTPUTDEBUGSTRING(str)	(void)(0)

#endif

#define IRIS_STATIC_ASSERT(exp)		static_assert(exp, #exp)

#endif
