//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_limits.h
 * @brief		limits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_limits_H_
#define INCG_IRIS_iris_limits_H_

//======================================================================
// define
#if	!defined(__STDC_LIMIT_MACROS)
#  define __STDC_LIMIT_MACROS	// iris ł͒`
#endif

//======================================================================
// include
#include "iris_compiler.h"
#include <limits.h>

//======================================================================
// define

//--------------------
// long long
#if		!defined(ULLONG_MAX)
#  if	defined(IRIS_MWERKS)
#    if		_MSL_LONGLONG
#       define ULLONG_MAX	_MSL_ULLONG_MAX
#		define LLONG_MAX	_MSL_LLONG_MAX
#		define LLONG_MIN	_MSL_LLONG_MIN
#    endif
#  else
#    if		defined(ULONG_LONG_MAX)
#      define ULLONG_MAX	ULONG_LONG_MAX
#      define LLONG_MAX		LONG_LONG_MAX
#      define LLONG_MIN		LONG_LONG_MIN
#    elif		defined(ULONGLONG_MAX)
#      define ULLONG_MAX	ULONGLONG_MAX
#      define LLONG_MAX		LONGLONG_MAX
#      define LLONG_MIN		LONGLONG_MIN
#    endif
#  endif
#endif
#if		!defined(ULONG_MAX)
#  if		defined(IRIS_MWERKS)
#    define	ULONG_MAX	_MSL_ULONG_MAX
#    define	LONG_MAX	_MSL_LONG_MAX
#    define	LONG_MIN	_MSL_LONG_MIN
#  elif	defined(IRIS_AARM)
#    define	ULONG_MAX	0xffffffffUL
#    define	LONG_MAX	2147483647L
#    define	LONG_MIN	(-2147483647L - 1)
#  else
#    define	ULONG_MAX	0xffffffffUL
#    define	LONG_MAX	2147483647L
#    define	LONG_MIN	(-2147483647L - 1)
#  endif
#endif

#if		!defined(ULLONG_MAX)
#  define	_IRIS_NOT_SUPPORT_LLONG
#endif

//--------------------
// _INTEGRAL_MAX_BITS
#if	!defined(_INTEGRAL_MAX_BITS)
#  if	defined(_IRIS_NOT_SUPPORT_LLONG)
#    if		(ULONG_MAX == 0xffffffffUL)
#      define	_INTEGRAL_MAX_BITS	32
#    elif	(ULONG_MAX == 0xFFFFFFFFFFFFFFFF)
#      define	_INTEGRAL_MAX_BITS	64
#    else
#      error	iris not support
#    endif
#  else
#    if		defined(__have_longlong64)
#      define	_INTEGRAL_MAX_BITS	64
#    elif	(ULLONG_MAX == 0xFFFFFFFFFFFFFFFF)
#      define	_INTEGRAL_MAX_BITS	64
#    elif	(LONG_MAX > 0x7fffffffUL)
#      define	_INTEGRAL_MAX_BITS	64
#    elif	(ULLONG_MAX == 0xFFFFFFFF)
#      define	_INTEGRAL_MAX_BITS	32
#    else
#      error	iris not support
#    endif
#  endif
#endif
#define IRIS_INTEGRAL_MAX_BITS	_INTEGRAL_MAX_BITS


#if	!defined(__cplusplus) && !defined(__STDC_LIMIT_MACROS)
#  define __STDC_LIMIT_MACROS
#endif

#endif
