//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_macros.h
 * @brief		}Nt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_macros_H_
#define INCG_IRIS_iris_macros_H_

//======================================================================
// include
#include "preprocessor/PPBitCalc.h"
#include "preprocessor/PPColor.h"
#include "preprocessor/PPEndian.h"
#include "preprocessor/PPString.h"
#include "preprocessor/PPUnit.h"
#include "preprocessor/PPWarning.h"
#include "preprocessor/program/PPClass.h"
#include "iris_pragma.h"

//======================================================================
// macros
//----------------------------------------
// }N
//#define IRIS_SAFE_C_DELETE(a)  		do { if(a) { delete (a); (a) = nullptr; } } while(0)
//#define IRIS_SAFE_C_DELETE_ARRAY(a)	do { if(a) { delete [] (a); (a) = nullptr; } } while(0)
#define IRIS_SAFE_C_DELETE(a)  			do { delete (a); (a) = nullptr; } while(0)
#define IRIS_SAFE_C_DELETE_ARRAY(a)		do { delete [] (a); (a) = nullptr; } while(0)
#define IRIS_SAFE_C_RELEASE(a)	 		do { if(a) { (a)->Release(); (a) = nullptr; } } while(0)

#if defined(__cplusplus)
#include "c++0x/cpp0x_nullptr.h"	// nullptr

namespace iris
{
	template<typename TN>
	STATICINLINE void SafeDelete(TN*& a)		{ delete a; a = nullptr; }
	template<typename TN>
	STATICINLINE void SafeDeleteArray(TN*& a)	{ delete [] a; a = nullptr; }
	template<typename TN>
	STATICINLINE void SafeRelease(TN*& a)		{ if( a != nullptr ) { a->Release(); } a = nullptr; }
}
#  define IRIS_SAFE_DELETE(a)  		SafeDelete(a)
#  define IRIS_SAFE_DELETE_ARRAY(a)	SafeDeleteArray(a)
#  define IRIS_SAFE_RELEASE(a)	 	SafeRelease(a)
#else
#  define IRIS_SAFE_DELETE(a)  		IRIS_SAFE_C_DELETE(a)
#  define IRIS_SAFE_DELETE_ARRAY(a)	IRIS_SAFE_C_DELETE_ARRAY(a)
#  define IRIS_SAFE_RELEASE(a)	 	IRIS_SAFE_C_RELEASE(a)
#endif

//----------------------------------------
// bool -> BOOL
#define IRIS_TO_BOOL(b)			((b) ? TRUE : FALSE)
// BOOL -> bool
#define IRIS_TO_bool(B)			((B) != FALSE)

#if	!defined(__cplusplus)
// max
#  ifndef	max
#    define max(a, b)	(((a) < (b)) ? (b) : (a))
#  endif
// min
#  ifndef	min
#    define min(a, b)	(((b) < (a)) ? (b) : (a))
#  endif
#endif

// ZeroMemory
#ifndef ZeroMemory
#  define ZeroMemory(Destination, Length)	memset((Destination), 0, (Length))
#endif

#ifdef UNICODE
#  define _tstring	wstring	//!< std::(w)string
#else
#  define _tstring	string	//!< std::(w)string
#endif

// extern "C"
#ifndef EXTERN_C
#  if defined(__cplusplus)
#    define EXTERN_C	extern "C"
#  else
#    define EXTERN_C	extern
#  endif
#endif

// extern "C" scope
#ifndef EXTERN_C_BEGIN
#  if defined(__cplusplus)
#    define EXTERN_C_BEGIN	extern "C" {
#  else
#    define EXTERN_C_BEGIN
#  endif
#endif

#ifndef EXTERN_C_END
#  if defined(__cplusplus)
#    define EXTERN_C_END	}
#  else
#    define EXTERN_C_END
#  endif
#endif

// extern "C++"
#ifndef EXTERN_CPP
#  if defined(__cplusplus)
#    define EXTERN_CPP	extern
#  else
#    define EXTERN_CPP	extern "C++"
#  endif
#endif

#ifndef EXTERN_CPP_BEGIN
#  if defined(__cplusplus)
#    define EXTERN_CPP_BEGIN
#  else
#    define EXTERN_CPP_BEGIN	extern "C++" {
#  endif
#endif

#ifndef EXTERN_CPP_END
#if defined(__cplusplus)
#define EXTERN_CPP_END
#else
#define EXTERN_CPP_END	}
#endif
#endif

#ifndef NAMESPACE_BEGIN
#  if defined(__cplusplus)
#    define NAMESPACE_BEGIN(name_)	namespace name_ {
#  else
#    define NAMESPACE_BEGIN(name_)
#  endif
#endif

#ifndef NAMESPACE_END
#  if defined(__cplusplus)
#    define NAMESPACE_END()	}
#  else
#    define NAMESPACE_END()
#  endif
#endif

#ifndef CONCEAL_SCOPE_BEGIN
#  if defined(__cplusplus)
#    define CONCEAL_SCOPE_BEGIN	namespace {
#  else
#    define CONCEAL_SCOPE_BEGIN
#  endif
#endif

#ifndef CONCEAL_SCOPE_END
#  if defined(__cplusplus)
#    define CONCEAL_SCOPE_END	}
#  else
#    define CONCEAL_SCOPE_END
#  endif
#endif

#if defined(__cplusplus)
namespace iris
{
#endif

//======================================================================
// macros
// f32 macros
#define F32_Mul(a, b)			((a)*(b))			//!< Z
#define F32_Div(a, b)			((a)/(b))			//!< Z
#define F32_Sqrt(d_v)			sqrtf(d_v)			//!< ݏ捪
#define F32_Rsqrt(d_v)			(1.0f/sqrtf(d_v))	//!< ݏ捪

#define F32_Abs(d_v)			fabsf((d_v))				//!< abs
#define F32_Ceil(d_v)			ceilf((d_v))				//!< ceil
#define F32_Trunc(d_v)			(IrisF32)((IrisS32)(d_v))	//!< trunc	TODO:
#define F32_Floor(d_v)			floorf((d_v))				//!< floor
#define F32_Round(d_v)			roundf(d_v)					//!< round

#define F32_RAD2IDX(rd)			((rd)*0x10000/F32_2PI)		//!< WAl->16bitCfbNX
#define F32_IDX2RAD(idx)		((F32_2PI*(idx))/0x10000)	//!< 16bitCfbNX->WAl

#define F32_Sin(rd)				sinf(rd)			//!< sin
#define F32_Cos(rd)				cosf(rd)			//!< cos
#define F32_Tan(rd)				tanf(rd)			//!< tan
#define F32_SinIdx(idx)			F32_Sin(F32_IDX2RAD(idx))		//!< sin
#define F32_CosIdx(idx)			F32_Cos(F32_IDX2RAD(idx))		//!< cos
#define F32_TanIdx(idx)			F32_Tan(F32_IDX2RAD(idx))		//!< tan
#define F32_Asin(d_v)			asinf(d_v)						//!< asin
#define F32_Acos(d_v)			acosf(d_v)						//!< acos
#define F32_AsinIdx(d_v)		F32_RAD2IDX(F32_Asin(d_v))		//!< asin
#define F32_AcosIdx(d_v)		F32_RAD2IDX(F32_Acos(d_v))		//!< acos
#define F32_Atan(d_v)			atanf(d_v)							//!< atan
#define F32_Atan2(d_vy, d_vx)	atan2f(d_vy, d_vx)					//!< atan2
#define F32_AtanIdx(d_v)		F32_RAD2IDX(F32_Atan(d_v))			//!< atan
#define F32_Atan2Idx(rdy, rdx)	F32_RAD2IDX(F32_Atan2(d_vy, d_vx))	//!< atan2

#define F32_Exp(d_v)			expf((d_v))				//!< exp
#define F32_Log(d_v)			logf((d_v))				//!< log
#define F32_Log2(d_v)			(logf(d_v) / logf(2.0f))//!< log2
#define F32_Log10(d_v)			log10f((d_v))			//!< log10
#define F32_Pow(x, y)			powf(x, y)			//!< pow
#define F32_Pow2(d_v)			powf(2.0f, d_v)		//!< pow2
#define F32_Hypot(x, y)			hypotf(x, y)		//!< hypot

#define F32_PI					3.14159265358979323846f	//!< 
#define F32_2PI					(F32_PI*2.0f)			//!< 2


// f64 macros
#define F64_Abs(d_v)			fabs((d_v))				//!< abs
#define F64_Ceil(d_v)			ceil((d_v))				//!< ceil
#define F64_Trunc(d_v)			(IrisF64)((IrisS64)(d_v))		//!< trunc	TODO:
#define F64_Floor(d_v)			floor((d_v))			//!< floor
#define F64_Round(d_v)			F64_Floor((d_v)+0.5)	//!< round
#define F64_Pow(x, y)			::pow(x, y)				//!< pow
#define F64_Pow2(d_v)			::pow(2.0, d_v)			//!< pow2

#if defined(__cplusplus)
}	// end of namespace iris
#endif

#endif
