//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_math.h
 * @brief		iris math ֐T|[g t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_math_H_
#define INCG_IRIS_iris_math_H_

//======================================================================
// include
#include "iris_inchead.h"
#if	defined(__cplusplus)
#  include "ml/iml_math.hpp"
#endif
#include <math.h>

//======================================================================
// define
#if	defined(IRIS_MSC)
#  define hypot			_hypot
#endif

//======================================================================
// function

#if		defined(IRIS_WIN32)
#  if		defined(IRIS_WIN32_WCE)

//STATICINLINE float	powf(float a, float b)	{ return (float)pow((double)a, (double)b); }
//STATICINLINE float	logf(float x)			{ return (float)log((double)x); }
//STATICINLINE float	log10f(float x)			{ return (float)log10((double)x); }
//STATICINLINE float	expf(float x)			{ return (float)exp((double)x); }
//STATICINLINE float	sinf(float x)			{ return (float)sin((double)x); }
//STATICINLINE float	cosf(float x)			{ return (float)cos((double)x); }
//STATICINLINE float	tanf(float x)			{ return (float)tan((double)x); }
//STATICINLINE float	asinf(float x)			{ return (float)asin((double)x); }
//STATICINLINE float	acosf(float x)			{ return (float)acos((double)x); }
//STATICINLINE float	atanf(float x)			{ return (float)atan((double)x); }
//STATICINLINE float	atan2f(float x, float y){ return (float)atan2((double)x, (double)y); }

#  endif

#if IRIS_MSC_AT_LESS(_MSC_VER_VC10)
STATICINLINE float	hypotf(float a, float b){ return (float)hypot((double)a, (double)b); }
#endif

#elif	defined(IRIS_MWERKS)

STATICINLINE float	log10f(float x)			{ return (float)log10((double)x); }

#elif	defined(IRIS_GNUC)

STATICINLINE float	hypotf(float a, float b){ return (float)hypot((double)a, (double)b); }

#else

STATICINLINE float	hypotf(float a, float b){ return (float)hypot((double)a, (double)b); }

#endif

STATICINLINE double	rcp(double x)			{ return 1.0/x; }
STATICINLINE float	rcpf(float x)			{ if( (*(long*)&x & 0x7FFFFFFF) == 0 ) return MATH_F32_P_INF_BITS; return 1.0f/x; }
STATICINLINE double	rsqrt(double x)			{ return 1.0/sqrt(x); }
STATICINLINE float	rsqrtf(float x)			{ return 1.0f/sqrtf(x); }


#endif
