//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_rtti.h
 * @brief		RTTIp`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_rtti_H_
#define INCG_IRIS_iris_rtti_H_

//======================================================================
#include "iris_compiler.h"

//======================================================================
// define
#if		defined(IRIS_MSC)			// visual studio
#  ifdef _CPPRTTI
#    ifndef _IRIS_SUPPORT_RTTI
#      define _IRIS_SUPPORT_RTTI
#    endif
#  else	// #ifdef _CPPRTTI
#    ifdef _IRIS_SUPPORT_RTTI
#      undef _IRIS_SUPPORT_RTTI
#    endif
#  endif	// #ifdef _CPPRTTI
#elif	defined(IRIS_BORLANDC)
#  define _IRIS_SUPPORT_RTTI
#elif	defined(IRIS_MWERKS)
#  if	__option(RTTI)
#    ifndef _IRIS_SUPPORT_RTTI
#      define _IRIS_SUPPORT_RTTI
#    endif
#  else	// #if __option(RTTI)
#    ifdef _IRIS_SUPPORT_RTTI
#      undef _IRIS_SUPPORT_RTTI
#    endif
#  endif	// #if __option(RTTI)
#elif	defined(IRIS_APPLE)
#  ifdef IRIS_GNUC
#    ifndef _IRIS_SUPPORT_RTTI
#      define _IRIS_SUPPORT_RTTI
#    endif
#  else	// #if IRIS_GNUC
#    if	__option(RTTI)
#      ifndef _IRIS_SUPPORT_RTTI
#        define _IRIS_SUPPORT_RTTI
#      endif
#    else	// #if __option(RTTI)
#      ifdef _IRIS_SUPPORT_RTTI
#        undef _IRIS_SUPPORT_RTTI
#      endif
#    endif	// #if __option(RTTI)
#  endif	// #if __GNUC__
#elif	defined(IRIS_CC_ARM)
#  ifdef __RTTI
#    if		!defined(_IRIS_SUPPORT_RTTI)
#      define _IRIS_SUPPORT_RTTI
#    endif
#  else
#    if		defined(_IRIS_SUPPORT_RTTI)
#      undef _IRIS_SUPPORT_RTTI
#    endif
#  endif
#else	// other
#endif

#if defined(__cplusplus)

#ifndef _IRIS_SUPPORT_RTTI
#  define dynamic_cast	static_cast
#endif

// dcast gꍇ́Adynamic_cast̓OƂɂĂ͂ȂB
// ̏ꍇ́Adynamic_cast𒼐ڎgp邱
#ifdef	_IRIS_SUPPORT_DCAST_DYNAMIC
#  define dcast	dynamic_cast
#else
#  define dcast	static_cast
#endif

// typeinfo
#ifndef _IRIS_SUPPORT_RTTI
#if !defined(__MWERKS__)

namespace rtti_
{
	template<typename TN>
	struct TypeIdHelper { public: static bool _dummy; };
	template<typename TN>bool TypeIdHelper<TN>::_dummy = false;
}

#ifndef _TYPEINFO_

class type_info
{
	typedef void*	type;
private:
	type	m_id;
private:
	type_info(void) {}
	type_info(const type_info&) {}
public:
	explicit type_info(type id) : m_id(id) {}
public:
	bool	operator == (const type_info& rhs) const { return m_id == rhs.m_id; }
	bool	operator != (const type_info& rhs) const { return m_id != rhs.m_id; }
};

#endif

#if IRIS_MSC_AT_LEAST(1400) && !defined(IRIS_WIN32_WCE)
template<typename TN>
inline type_info	typeid(TN type)	{ type_info t(&rtti_::TypeIdHelper<TN>::_dummy); return t; }
#endif

#endif
#endif

#endif	// #if defined(__cplusplus)

#endif
