//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_stdint.h
 * @brief		stdint.hΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_stdint_H_
#define INCG_IRIS_iris_stdint_H_

//======================================================================
// include
#if	!defined(_STDINT_H) && !defined(__stdint_h)
#  if	!defined(__STDC_CONSTANT_MACROS)
#    define __STDC_CONSTANT_MACROS	// iris ł͒`
#  endif
#endif

#include "iris_compiler.h"
#include "iris_limits.h"

#if	!defined(_STDINT_H) && !defined(__stdint_h)

#if	defined(_IRIS_HAS_C99_H)
#  include <stdint.h>
#else

#if !defined(__cplusplus) && !defined(__STDC_CONSTANT_MACROS)
#  define __STDC_CONSTANT_MACROS
#endif

// stdint.hȂ̂ő̎
//======================================================================
// typedef & define
// 8
#if		(UCHAR_MAX == 0xFF)
typedef signed char		int8_t;
typedef signed char		int_least8_t;
typedef signed char		int_fast8_t;
typedef unsigned char	uint8_t;
typedef unsigned char	uint_least8_t;
typedef unsigned char	uint_fast8_t;
#else
#  error iris not support
#endif

// 16
#if		(USHRT_MAX == 0xFFFF)
typedef short			int16_t;
typedef short			int_least16_t;
typedef short			int_fast16_t;
typedef unsigned short	uint16_t;
typedef unsigned short	uint_least16_t;
typedef unsigned short	uint_fast16_t;
#else
#  error iris not support
#endif

// 32
#if		defined(_WIN32)
typedef __int32				int32_t;
typedef __int32				int_least32_t;
typedef __int32				int_fast32_t;
typedef unsigned __int32	uint32_t;
typedef unsigned __int32	uint_least32_t;
typedef unsigned __int32	uint_fast32_t;
#elif	(ULONG_MAX == 0xFFFFFFFF)
typedef long			int32_t;
typedef long			int_least32_t;
typedef long			int_fast32_t;
typedef unsigned long	uint32_t;
typedef unsigned long	uint_least32_t;
typedef unsigned long	uint_fast32_t;
#  elif	(UINT_MAX = 0xFFFFFFFF)
typedef int				int32_t;
typedef int				int_least32_t;
typedef int				int_fast32_t;
typedef unsigned int	uint32_t;
typedef unsigned int	uint_least32_t;
typedef unsigned int	uint_fast32_t;
#else
#  error iris not support
#endif

// 64
#if		defined(_WIN32)
typedef __int64				int64_t;
typedef __int64				int_least64_t;
typedef __int64				int_fast64_t;
typedef unsigned __int64	uint64_t;
typedef unsigned __int64	uint_least64_t;
typedef unsigned __int64	uint_fast64_t;
#elif		!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 18446744073709551615ULL)
__extension__ typedef long long				int64_t;
__extension__ typedef long long				int_least64_t;
__extension__ typedef long long				int_fast64_t;
__extension__ typedef unsigned long long	uint64_t;
__extension__ typedef unsigned long long	uint_least64_t;
__extension__ typedef unsigned long long	uint_fast64_t;
#elif	(ULLONG_MAX != 0xFFFFFFFF)
#  if	(ULONG_MAX == 18446744073709551615)
typedef long				int64_t;
typedef long				int_least64_t;
typedef long				int_fast64_t;
typedef unsigned long		uint64_t;
typedef unsigned long		uint_least64_t;
typedef unsigned long		uint_fast64_t;
#  else
#    error iris not support
#  endif
#elif	defined(IRIS_BORLANDC) || defined(IRIS_MSC)
typedef __int64				int64_t;
typedef __int64				int_least64_t;
typedef __int64				int_fast64_t;
typedef unsigned __int64	uint64_t;
typedef unsigned __int64	uint_least64_t;
typedef unsigned __int64	uint_fast64_t;
#else
#endif

#if		defined(_IRIS_SUPPORT_INT128)
typedef __int128			intmax_t;
typedef unsigned __int128	uintmax_t;
typedef __int128			int128_t;
typedef __int128			int_least128_t;
typedef __int128			int_fast128_t;
typedef unsigned __int128	uint128_t;
typedef unsigned __int128	uint_least128_t;
typedef unsigned __int128	uint_fast128_t;
#else
__extension__ typedef int64_t	intmax_t;
__extension__ typedef uint64_t	uintmax_t;
#endif

#if		defined(_IRIS32)
#  if		!defined(_INTPTR_T_DEFINED)
typedef int32_t				intptr_t;
#  endif
#  if		!defined(_UINTPTR_T_DEFINED)
typedef uint32_t			uintptr_t;
#  endif
typedef int32_t				intfast_t;
typedef uint32_t			uintfast_t;
#elif	defined(_IRIS64)
#  if		!defined(_INTPTR_T_DEFINED)
typedef int64_t				intptr_t;
#  endif
#  if		!defined(_UINTPTR_T_DEFINED)
typedef uint64_t			uintptr_t;
#  endif
typedef int64_t				intfast_t;
typedef uint64_t			uintfast_t;
#else
#  error iris not support
#endif

#if	defined(__STDC_CONSTANT_MACROS)
#  define INT8_C(c)			c
#  define UINT8_C(c)		IRIS_PP_CAT(c, U)
#  define INT16_C(c)		c
#  define UINT16_C(c)		IRIS_PP_CAT(c, U)
#  if		(ULONG_MAX == 0xFFFFFFFF)
#    define INT32_C(c)		IRIS_PP_CAT(c, L)
#    define UINT32_C(c)		IRIS_PP_CAT(c, UL)
#    elif	(UINT_MAX = 0xFFFFFFFF)
#    define INT32_C(c)		c
#    define UINT32_C(c)		IRIS_PP_CAT(c, U)
#  else
#    error iris not support
#  endif
#  if		!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 0xffffffffffffffffULL)
#    define INT64_C(c)			IRIS_PP_CAT(c, LL)
#    define UINT64_C(c)			IRIS_PP_CAT(c, ULL)
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define INTMAX_C(c)		INT64_C(c)
#      define UINTMAX_C(c)		UINT64_C(c)
#    endif
#  elif	(ULONG_MAX != 0xFFFFFFFF)
#    if	(ULONG_MAX == 18446744073709551615)
#      define INT64_C(c)		IRIS_PP_CAT(c, L)
#      define UINT64_C(c)		IRIS_PP_CAT(c, UL)
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define INTMAX_C(c)		INT64_C(c)
#        define UINTMAX_C(c)	UINT64_C(c)
#      endif
#    else
#      error iris not support
#    endif
#  elif	defined(IRIS_BORLANDC) || defined(IRIS_MSC)
#    define INT64_C(c)			IRIS_PP_CAT(c, i64)
#    define UINT64_C(c)			IRIS_PP_CAT(c, ui64)
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define INTMAX_C(c)		INT64_C(c)
#      define UINTMAX_C(c)		UINT64_C(c)
#    endif
#  else
#    define INT64_C(c)			c
#    define UINT64_C(c)			c
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define INTMAX_C(c)		INT32_C(c)
#      define UINTMAX_C(c)		UINT32_C(c)
#    endif
#  endif
#  if		defined(_IRIS_SUPPORT_INT128)
#    define INT128_C(c)			IRIS_PP_CAT(c, i128)
#    define UINT128_C(c)		IRIS_PP_CAT(c, ui128)
#    define INTMAX_C(c)			INT128_C(c)
#    define UINTMAX_C(c)		UINT128_C(c)
#  endif
#endif

#endif

#endif	// stdint

//----------------------------------------
// for iris
// CONSTANT_MACROS `ĂȂꍇ
#if	!defined(__STDC_CONSTANT_MACROS)
#  define IRIS_INT8_C(c)		c
#  define IRIS_UINT8_C(c)		IRIS_PP_CAT(c, U)
#  define IRIS_INT16_C(c)		c
#  define IRIS_UINT16_C(c)		IRIS_PP_CAT(c, U)
#  if		(ULONG_MAX == 0xFFFFFFFF)
#    define IRIS_INT32_C(c)		IRIS_PP_CAT(c, L)
#    define IRIS_UINT32_C(c)	IRIS_PP_CAT(c, UL)
#    elif	(UINT_MAX == 0xFFFFFFFF)
#    define IRIS_INT32_C(c)	c
#    define IRIS_UINT32_C(c)	IRIS_PP_CAT(c, U)
#  else
#    error iris not support
#  endif
#  if		!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 0xffffffffffffffffULL)
#    define IRIS_INT64_C(c)			IRIS_PP_CAT(c, LL)
#    define IRIS_UINT64_C(c)		IRIS_PP_CAT(c, ULL)
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define IRIS_INTMAX_C(c)		IRIS_INT64_C(c)
#      define IRIS_UINTMAX_C(c)		IRIS_UINT64_C(c)
#    endif
#  elif	(ULONG_MAX != 0xFFFFFFFF)
#    if	(ULONG_MAX == 18446744073709551615)
#      define IRIS_INT64_C(c)		IRIS_PP_CAT(c, L)
#      define IRIS_UINT64_C(c)		IRIS_PP_CAT(c, UL)
#      if		!defined(_IRIS_SUPPORT_INT128)
#        define IRIS_INTMAX_C(c)	IRIS_INT64_C(c)
#        define IRIS_UINTMAX_C(c)	IRIS_UINT64_C(c)
#      endif
#    else
#      error iris not support
#    endif
#  elif	defined(IRIS_BORLANDC) || defined(IRIS_MSC)
#    define IRIS_INT64_C(c)			IRIS_PP_CAT(c, i64)
#    define IRIS_UINT64_C(c)		IRIS_PP_CAT(c, ui64)
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define IRIS_INTMAX_C(c)		IRIS_INT64_C(c)
#      define IRIS_UINTMAX_C(c)		IRIS_UINT64_C(c)
#    endif
#  else
#    define IRIS_INT64_C(c)				c
#    define IRIS_UINT64_C(c)			c
#    if		!defined(_IRIS_SUPPORT_INT128)
#      define IRIS_INTMAX_C(c)			IRIS_INT32_C(c)
#      define IRIS_UINTMAX_C(c)			IRIS_UINT32_C(c)
#    endif
#  endif
#  if		defined(_IRIS_SUPPORT_INT128)
#    define IRIS_INT128_C(c)		IRIS_PP_CAT(c, i128)
#    define IRIS_UINT128_C(c)		IRIS_PP_CAT(c, ui128)
#    define IRIS_INTMAX_C(c)		IRIS_INT128_C(c)
#    define IRIS_UINTMAX_C(c)		IRIS_UINT128_C(c)
#  endif
#else
#  define IRIS_INT8_C(c)		INT8_C(c)
#  define IRIS_UINT8_C(c)		UINT8_C(c)
#  define IRIS_INT16_C(c)		INT16_C(c)
#  define IRIS_UINT16_C(c)		UINT16_C(c)
#  define IRIS_INT32_C(c)		INT32_C(c)
#  define IRIS_UINT32_C(c)		UINT32_C(c)
#  define IRIS_INT64_C(c)		INT64_C(c)
#  define IRIS_UINT64_C(c)		UINT64_C(c)
#  define IRIS_INTMAX_C(c)		INTMAX_C(c)
#  define IRIS_UINTMAX_C(c)		UINTMAX_C(c)
#endif

// 萔}N
#define S8_C(c)			c
#define S16_C(c)		c
#define S32_C(c)		IRIS_PP_CAT(c, L)
#define S64_C(c)		INT64_C(c)
#define U8_C(c)			IRIS_PP_CAT(c, U)
#define U16_C(c)		IRIS_PP_CAT(c, U)
#define U32_C(c)		IRIS_PP_CAT(c, UL)
#define U64_C(c)		UINT64_C(c)
#define F32_C(c)		IRIS_PP_CAT(c, f)
#define F64_C(c)		c


#endif
