//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_xchar.hpp
 * @brief		iris_xchar t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_xchar_HPP_
#define INCG_IRIS_iris_xchar_HPP_

//======================================================================
// include
#include "iris_object.h"

#if defined(__cplusplus)
#include "c++0x/cpp0x_type_traits.hpp"

//======================================================================
// define
#define IRIS_XTEXT(type_, txt_)			IRIS_XTEXT_IMPL(type_, txt_)
#define IRIS_XTEXT_IMPL(type_, txt_)	::iris::xcs<type_>::type::constant(txt_, L##txt_)

namespace iris
{

//======================================================================
// function
#if IRIS_MSC_AT_LESS(_MSC_VER_VC8)
	IRIS_MSC_PRAGMA_WARNING_BEGIN();
	IRIS_MSC_PRAGMA_WARNING_DISABLE(4068)
#endif

#if 1	// xcscpy_s
	template<typename T1, typename T2>
	STATICINLINE errno_t xcscpy_s(T1* dst, size_t size, T2 const& src);

	template<typename T>
	STATICINLINE errno_t xcscpy_s(LPSTR dst, size_t size, T const& src)
	{
		return strcpy_s(dst, size, src);
	}

	template<typename T>
	STATICINLINE errno_t xcscpy_s(LPWSTR dst, size_t size, T const& src)
	{
		return wcscpy_s(dst, size, src);
	}

#endif

#if 1	// xcscat_s
	template<typename T>
	STATICINLINE errno_t xcscat_s(T* dst, size_t size, const T* src);

	template<>
	STATICINLINE errno_t xcscat_s(LPSTR dst, size_t size, LPCSTR src)
	{
		return strcat_s(dst, size, src);
	}

	template<>
	STATICINLINE errno_t xcscat_s(LPWSTR dst, size_t size, LPCWSTR src)
	{
		return wcscat_s(dst, size, src);
	}
#endif

#if 1	// xcschr
	template<typename T>
	STATICINLINE const T*	xcschr(const T* src, T ch);
	template<typename T>
	STATICINLINE T*			xcschr(T* src, T ch);

	template<>
	STATICINLINE LPCSTR		xcschr(LPCSTR src, CHAR ch)
	{
		return strchr(src, ch);
	}
	template<>
	STATICINLINE LPSTR		xcschr(LPSTR src, CHAR ch)
	{
		return strchr(src, ch);
	}

	template<>
	STATICINLINE LPCWSTR	xcschr(LPCWSTR src, WCHAR ch)
	{
		return wcschr(src, ch);
	}
	template<>
	STATICINLINE LPWSTR		xcschr(LPWSTR src, WCHAR ch)
	{
		return wcschr(src, ch);
	}
#endif

#if 1	// xcsrchr
	template<typename T>
	STATICINLINE const T*	xcsrchr(const T* src, T ch);
	template<typename T>
	STATICINLINE T*			xcsrchr(T* src, T ch);

	template<>
	STATICINLINE LPCSTR		xcsrchr(LPCSTR src, CHAR ch)
	{
		return strrchr(src, ch);
	}
	template<>
	STATICINLINE LPSTR		xcsrchr(LPSTR src, CHAR ch)
	{
		return strrchr(src, ch);
	}

	template<>
	STATICINLINE LPCWSTR	xcsrchr(LPCWSTR src, WCHAR ch)
	{
		return wcsrchr(src, ch);
	}
	template<>
	STATICINLINE LPWSTR		xcsrchr(LPWSTR src, WCHAR ch)
	{
		return wcsrchr(src, ch);
	}
#endif

#if 1	// xcsstr
	template<typename T>
	STATICINLINE const T*	xcsstr(const T* src, const T* ch);
	template<typename T>
	STATICINLINE T*			xcsstr(T* src, T* ch);

	template<>
	STATICINLINE LPCSTR		xcsstr(LPCSTR src, LPCSTR ch)
	{
		return strstr(src, ch);
	}
	template<>
	STATICINLINE LPSTR		xcsstr(LPSTR src, LPSTR ch)
	{
		return strstr(src, ch);
	}

	template<>
	STATICINLINE LPCWSTR	xcsstr(LPCWSTR src, LPCWSTR ch)
	{
		return wcsstr(src, ch);
	}
	template<>
	STATICINLINE LPWSTR		xcsstr(LPWSTR src, LPWSTR ch)
	{
		return wcsstr(src, ch);
	}
#endif

#if 1	// xcsrstr
	//template<typename T>
	//STATICINLINE const T*	xcsrstr(const T* src, const T* ch);
	//template<typename T>
	//STATICINLINE T*			xcsrstr(T* src, T* ch);

	//template<>
	//STATICINLINE LPCSTR		xcsrstr(LPCSTR src, LPCSTR ch)
	//{
	//	return strrstr(src, ch);
	//}
	//template<>
	//STATICINLINE LPSTR		xcsrstr(LPSTR src, LPSTR ch)
	//{
	//	return strrstr(src, ch);
	//}

	//template<>
	//STATICINLINE LPCWSTR	xcsrstr(LPCWSTR src, LPCWSTR ch)
	//{
	//	return wcsrstr(src, ch);
	//}
	//template<>
	//STATICINLINE LPWSTR		xcsrstr(LPWSTR src, LPWSTR ch)
	//{
	//	return wcsrstr(src, ch);
	//}
#endif

#if 1	// xcsrep
	//template<typename T>
	//STATICINLINE errno_t	xcsrep(T* dst, const T* src, const T* rep);

	//template<>
	//STATICINLINE errno_t	xcsrep(LPCSTR src, LPCSTR rep)
	//{
	//	return strstr(src, ch);
	//}

	//template<>
	//STATICINLINE errno_t	xcsrep(LPCWSTR src, LPCWSTR rep)
	//{
	//	return wcsstr(src, ch);
	//}
#endif

#if 1	// xcslen
	template<typename T>
	STATICINLINE size_t xcslen(const T* src);

	template<>
	STATICINLINE size_t xcslen(LPCSTR src)
	{
		return strlen(src);
	}

	template<>
	STATICINLINE size_t xcslen(LPCWSTR src)
	{
		return wcslen(src);
	}

	//template<typename T, SIZE_T SIZE>
	//STATICINLINE size_t xcslen(const T (&src)[SIZE])
	//{
	//	return SIZE;
	//}
#endif

#if 1	// xcstol
	template<typename T>
	STATICINLINE long xcstol(const T* src, T** end, int radix);

	template<>
	STATICINLINE long xcstol(LPCSTR src, CHAR** end, int radix)
	{
		return strtol(src, end, radix);
	}

	template<>
	STATICINLINE long xcstol(LPCWSTR src, WCHAR** end, int radix)
	{
		return wcstol(src, end, radix);
	}
#endif

#if 1	// xsprintf_s
	template<typename T>
	STATICINLINE int xsprintf_s(T* dst, size_t size, const T* fmt, ...);

	template<>
	STATICINLINE int xsprintf_s(LPSTR dst, size_t size, LPCSTR fmt, ...)
	{
		va_list va;
		va_start(va, fmt);
		int ret = vsprintf_s(dst, size, fmt, va);
		va_end(va);
		return ret;
	}

	template<>
	STATICINLINE int xsprintf_s(LPWSTR dst, size_t size, LPCWSTR fmt, ...)
	{
		va_list va;
		va_start(va, fmt);
		int ret = vswprintf_s(dst, size, fmt, va);
		va_end(va);
		return ret;
	}
#endif

#if 1	// xprintf
	template<typename T>
	STATICINLINE int xprintf(const T* fmt, ...);

	template<>
	STATICINLINE int xprintf(LPCSTR fmt, ...)
	{
		va_list va;
		va_start(va, fmt);
		int ret = vprintf(fmt, va);
		va_end(va);
		return ret;
	}

	template<>
	STATICINLINE int xprintf(LPCWSTR fmt, ...)
	{
		va_list va;
		va_start(va, fmt);
		int ret = vwprintf(fmt, va);
		va_end(va);
		return ret;
	}
#endif

#if 1	// xcscmp
	template<typename T1, typename T2>
	STATICINLINE int  xcscmp(const T1* str1, const T2* str2);

	template<>
	STATICINLINE int  xcscmp(LPCSTR str1, LPCSTR str2)
	{
		return strcmp(str1, str2);
	}

	template<>
	STATICINLINE int  xcscmp(LPCWSTR str1, LPCWSTR str2)
	{
		return wcscmp(str1, str2);
	}

	template<>
	STATICINLINE int  xcscmp(LPCSTR str1, LPCWSTR str2)
	{
		WCHAR tmp[1024];
		size_t written=0;
		mbstowcs_s(&written, tmp, 1024, str1, _TRUNCATE);
		return wcscmp(tmp, str2);
	}

	template<>
	STATICINLINE int  xcscmp(LPCWSTR str1, LPCSTR str2)
	{
		return xcscmp(str2, str1);
	}
#endif

#if 1	// xcsicmp
	template<typename T1, typename T2>
	STATICINLINE int  xcsicmp(const T1* str1, const T2* str2);

	template<>
	STATICINLINE int  xcsicmp(LPCSTR str1, LPCSTR str2)
	{
		return stricmp(str1, str2);
	}

	template<>
	STATICINLINE int  xcsicmp(LPCWSTR str1, LPCWSTR str2)
	{
		return wcsicmp(str1, str2);
	}

	template<>
	STATICINLINE int  xcsicmp(LPCSTR str1, LPCWSTR str2)
	{
		WCHAR tmp[1024];
		size_t written=0;
		mbstowcs_s(&written, tmp, 1024, str1, _TRUNCATE);
		return wcsicmp(tmp, str2);
	}

	template<>
	STATICINLINE int  xcsicmp(LPCWSTR str1, LPCSTR str2)
	{
		return xcsicmp(str2, str1);
	}
#endif

#if 1	// mbtoxc
	/**
	 * @brief	wctoxc
	 * @return	ϊɎgp o̓obt@
	*/
	template<typename T>
	STATICINLINE int  wctoxc(T* dst, size_t length, WCHAR src);

	template<>
	STATICINLINE int  wctoxc(LPWSTR str1, size_t length, WCHAR str2)
	{
		IRIS_UNUSED_VAR(length);
		*str1 = str2;
		return 1;
	}
	template<>
	STATICINLINE int  wctoxc(LPSTR str1, size_t length, WCHAR str2)
	{
		int ret=-1;
		wctomb_s(&ret, str1, length, str2);
		return ret;
	}
#endif

#if 1	// mbtoxc
	/**
	 * @brief	mbtoxc
	 * @return	ϊɎgp mb 
	*/
	template<typename T>
	STATICINLINE int  mbtoxc(T* dst, LPCSTR src, size_t count=MB_CUR_MAX);

	template<>
	STATICINLINE int  mbtoxc(LPWSTR str1, LPCSTR str2, size_t count)
	{
#if defined(IRIS_WIN32_WCE)
		int ret=0;
		mbstowcs_s(&ret, str1, 1, str2, count);
		return ret;
#else
		return mbtowc(str1, str2, count);
#endif
	}
	template<>
	STATICINLINE int  mbtoxc(LPSTR str1, LPCSTR str2, size_t count)
	{
		IRIS_UNUSED_VAR(count);
		*str1 = *str2;
		return 1;
	}
#endif

#if 1	// xctoxc
	template<typename T1, typename T2>
	STATICINLINE int  xctoxc(T1* dst, size_t length, const T2* src)
	{
		IRIS_UNUSED_VAR(length);
		*dst = *src;
		return 1;
	}
	template<>
	STATICINLINE int  xctoxc(LPWSTR str1, size_t length, LPCSTR str2)
	{
#if defined(IRIS_WIN32_WCE)
		int ret=0;
		mbstowcs_s(&ret, str1, length, str2, MB_CUR_MAX);
		return ret;
#else
		IRIS_UNUSED_VAR(length);
		return mbtowc(str1, str2, static_cast<size_t>(MB_CUR_MAX));
#endif
	}
	template<>
	STATICINLINE int  xctoxc(LPSTR str1, size_t length, LPCWSTR str2)
	{
		int ret=-1;
		wctomb_s(&ret, str1, length, *str2);
		return ret;
	}
#endif

#if 1	// xcstoxcs_s
	template<typename T1, typename T2>
	STATICINLINE errno_t xcstoxcs_s(T1* dst, size_t size, const T2* src)
	{
		return xcscpy_s(dst, size, src);
	}

	template<>
	STATICINLINE errno_t  xcstoxcs_s(LPSTR dst, size_t size, LPCWSTR src)
	{
		size_t written=0;
		return wcstombs_s(&written, dst, size, src, _TRUNCATE);
	}

	template<>
	STATICINLINE errno_t  xcstoxcs_s(LPWSTR dst, size_t size, LPCSTR src)
	{
		size_t written=0;
		return mbstowcs_s(&written, dst, size, src, _TRUNCATE);
	}

#endif

#if 1	// xcs
template<typename T>
struct xcs
{
private:
	template<typename TMP, typename TN>
	struct impl_select
	{
		template<typename TA, typename TB>
		static const TA	constant(const TA a, const TB b)
		{
			IRIS_UNUSED_VAR(b);
			return a;
		}
	};
	template<typename TMP>
	struct impl_select<TMP, WCHAR>
	{
		template<typename TA, typename TB>
		static const TB	constant(const TA a, const TB b)
		{
			IRIS_UNUSED_VAR(a);
			return b;
		}
	};

public:
	typedef impl_select<void, T>	type;
};
#endif

#if IRIS_MSC_AT_LESS(_MSC_VER_VC8)
  IRIS_MSC_PRAGMA_WARNING_END();
#endif

}	// end of namespace iris

#endif

#endif
