//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMacros.h
 * @brief		w֐p}Nt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathMacros_H_
#define INCG_IRIS_MathMacros_H_

//======================================================================
// include
#include "../iris_inchead.h"
#include "../iris_const.h"

#if defined(__cplusplus)
namespace iris {
namespace math
{
#endif

//======================================================================
// define
// f32
/// WAp-PI`PIɎ߂ij
#define MATH_F32_SAFE_RADIAN_EQUATION	( (x) < -MATH_F32_PI ?											\
										( (x) + ( (int)((-x) / MATH_F32_2PI) ) * MATH_F32_2PI )			\
										: (x) > MATH_F32_PI ?											\
										( (x) - ( (int)((x) / MATH_F32_2PI) ) * MATH_F32_2PI )			\
										: (x) )
/// WAp-PI`PIɎ߂ij
#define MATH_F32_SAFE_RADIAN_WHILE(x)	while((x) < -MATH_F32_PI) { (x) += MATH_F32_2PI; } \
										while((x) >  MATH_F32_PI) { (x) -= MATH_F32_2PI; }

/// [؎̂
// f = f32, u = f32(10.0f,100.0f,1000.0f...)
#define	MATH_F32_ROUNDDOWN(f, u)		((f32)((s32)(f * u) / u))
/// [؂グ
// f = f32, u = f32(10.0f,100.0f,1000.0f...)
#define MATH_F32_ROUNDUP(f, u)			((f32)((s32)((f+1.0f-MATH_F32_EPSIRON) * u) / u))



// xf32
/// WAp-PI`PIɎ߂ij
#define MATH_XF32_SAFE_RADIAN_EQUATION	( (x) < -MATH_XF32_PI ?											\
										( (x) + ( (int)((-x) / MATH_XF32_2PI) ) * MATH_XF32_2PI )		\
										: (x) >  MATH_XF32_PI ? 										\
										( (x) - ( (int)((x) / MATH_XF32_2PI) ) * MATH_XF32_2PI )		\
										: (x) )
/// WAp-PI`PIɎ߂ij
#define MATH_XF32_SAFE_RADIAN_WHILE(x)	while((x) < -MATH_XF32_PI) { (x) += MATH_XF32_2PI; } \
										while((x) >  MATH_XF32_PI) { (x) -= MATH_XF32_2PI; }

#if defined(__cplusplus)

}	// end of namespace math
}	// end of namespace iris
#endif

#endif
