//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPrimeNumber.h
 * @brief		ft@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPrimeNumber_H_
#define INCG_IRIS_MathPrimeNumber_H_

//======================================================================
// include
#include "../iris_inchead.h"

//======================================================================
// define
#if (defined(_IRIS_SUPPORT_PRIMENUMBER_TABLE_u32) || defined(_IRIS_SUPPORT_PRIMENUMBER_TABLE_u16))
#define	_IRIS_HAS_PRIME_TABLE
#else
#ifdef	_IRIS_HAS_PRIME_TABLE
#undef	_IRIS_HAS_PRIME_TABLE
#endif
#endif

namespace iris {
namespace math
{

//======================================================================
// function

// fe[u̎擾
u32*	GetPrimeNumberTable(void);
// fe[u̗vf擾
s32		GetPrimeNumberTableElements(void);
// f̎擾
u32		GetPrimeNumber(u32 nIndex);
// f̌
u32		FindPrimeNumber(u32 num);
// f̔
BOOL	IsPrimeNumber(u32 num);

}	// end of namespace math
}	// end of namespace iris

#endif
