//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathBSplineCurve.cpp
 * @brief		B-XvCȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathBSplineCurve_CPP_

//======================================================================
// include
#include "MathBSplineCurve.h"
#include "MathPolynomial.h"
#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// function
/**********************************************************************//**
 *
 * B-XvCȐ
 *
 -----------------------------------------------------------------------
 * @param [in]	t	= ( 0 <= t <= 1)
 * @param [in]	nn	= mbg
 * @param [in]	nv	= mbg
 * @param [in]	np	= _̐
 * @param [in]	pt	= _̔z(n)
 * @return o͒l
*//***********************************************************************/
f32	BSplineCurveArray(f32 t, s32 nn, f32 nv[], s32 np, f32 pt[])
{
	IRIS_ASSERT( nv != nullptr );
	IRIS_ASSERT( np >= 2 );
	IRIS_ASSERT( nn >= (np-1)*2 );
	IRIS_ASSERT( pt != nullptr );
	f32 ret = 0.0f;
	f32* pp = pt;
	IRIS_PRAGMA_MSG_TODO("Ȃ񂩊ԈĂ݂")

	for( s32 i=0; i < np; ++i, ++pp )
	{
		ret += F32_Mul( *pp, BSplinePolynomial(nn, i, t, nv) );
	}
	return ret;
}

}	// end of namespace math
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathBSplineCurveUnitTest, Func)
{
	IrisF32 P[] = {
		  0.0f,
		100.0f,
		  0.0f,
		200.0f
	};
	IrisF32 N[] = {
		1.0f,
		2.0f,
		3.0f,
		4.0f,
		5.0f,
		6.0f,
		7.0f,
		8.0f,
	};
	IrisS32 NP = sizeof(P)/sizeof(f32);
	IrisS32 NN = sizeof(N)/sizeof(f32);

	for( int i=0; i < 11; ++i )
	{
		std::cout << BSplineCurveArray(i/10.0f, NN, N, NP, P) << std::endl;
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
