//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathHermiteCurve.h
 * @brief		G~[gȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathHermiteCurve_H_
#define INCG_IRIS_MathHermiteCurve_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// declare
// G~[gȐԊ֐
STATICINLINE f32	HermiteCurve(f32 pt0, f32 vt0, f32 pt1, f32 vt1, f32 t);

//======================================================================
// function
/**
 * @brief	G~[gȐԊ֐
 * @param [in]	pt0	= n_
 * @param [in]	vt0	= n__
 * @param [in]	pt1	= I_
 * @param [in]	vt1	= I__
 * @param [in]	t	= (0`1)
 * @return o͒l
*/
STATICINLINE f32	HermiteCurve(f32 pt0, f32 vt0, f32 pt1, f32 vt1, f32 t)
{
	f32 t2 = F32_Mul(t, t);
	f32 t3 = F32_Mul(t, t2);
	return (F32_Mul(pt0, (( 2 * t3) - (3 * t2) + 1.0f))
		+	F32_Mul(vt0, ((     t3) - (2 * t2) + t   ))
		+	F32_Mul(pt1, ((-2 * t3) + (3 * t2)       ))
		+	F32_Mul(vt1, ((     t3) - (    t2)       ))
		);
}


}	// end of namespace math
}	// end of namespace iris

#endif
