//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPolynomial.h
 * @brief		w֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPolynomial_H_
#define INCG_IRIS_MathPolynomial_H_

//======================================================================
// include
#include "../MathPractical.h"
#include "../MathPower.h"

namespace iris {
namespace math
{

//======================================================================
// declare
STATICINLINE	f32		BernsteinPolynomial(s32 n, s32 i, f32 t);
STATICINLINE	f32		BSplinePolynomial(s32 n, s32 i, f32 t, f32 nv[]);

//======================================================================
// function

//======================================================================
// inline function
/**
 * @brief	o[X^C֐
 * @param [in]	n = 
 * @param [in]	i = 
 * @param [in]	t = (0 < t < 1)
 * @return	
*/
STATICINLINE f32	BernsteinPolynomial(s32 n, s32 i, f32 t)
{
	f32 it = 1.0f - t;
	s32 c = Combination(n, i);
	return c * F32_Mul( F32_Pow(t, (f32)i), F32_Pow(it, (f32)(n-i)));
}

/**
 * @brief	B-XvC֐
 * @param [in]	n	= 
 * @param [in]	i	= 
 * @param [in]	t	= 
 * @param [in]	nv	= 
 * @return	
*/
STATICINLINE f32	BSplinePolynomial(s32 n, s32 i, f32 t, f32 nv[])
{
	f32 d1 = 0.0f;
	f32 d2 = 0.0f;
	if( n == 1 )
	{
		if( t >= nv[i] && t < nv[i+1] ) return 1.0f;
		return 0.0f;
	}
	f32 k1 = nv[i+n] - nv[i+1];
	f32 k2 = nv[i+n-1] - nv[i];
	if( k1 != 0.0f )	d1 = F32_Mul( F32_Div(nv[i+n] - t, k1), BSplinePolynomial(n-1, i+1, t, nv) );
	if( k2 != 0.0f )	d2 = F32_Mul( F32_Div(t - nv[i]  , k2), BSplinePolynomial(n-1, i  , t, nv) );
	return d1 + d2;
}

}	// end of namespace math
}	// end of namespace iris

#endif
