//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathColor.cpp
 * @brief		J[Zt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathColor_CPP_

//======================================================================
// include
#include "MathColor.h"
#ifndef _IRIS_FPU_INLINE
	#include "inl/MathColor.inl"
#endif

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../graphics/gl/GXGLSystem.h"
#include "iris_using.h"

//======================================================================
// declare
static void displayFunc(void);

//======================================================================
// test
IRIS_UNITTEST(MathColorUnitTest, Munsell)
{
	IrisMunsellColor mc;
	mc.hg = HUE_BG;
	mc.h = 2.5f;
	mc.v = 4.0f;
	mc.s = 6.0f;
	IrisFHSV hsv;
	IrisFColor fc;
	IrisRGBA8888 tmp = { 0xFF006C60 };
	FpuColorFromRGBA8888(&fc, tmp);
	FpuColorToHSV(&hsv, &fc);
	FpuColorFromMunsell(&fc, &mc, 1.0f);
	IrisRGBA8888 argb = FpuColorToRGBA8888(&fc);

#if	defined(_IRIS_SUPPORT_OPENGL)
	COpenGL& gl = COpenGL::GetInstance();
	static const u32 buf_size = 4*1024*1024;	// 4KB
	void* buf = new u8 [buf_size];
	gx::gl::COpenGL::INIT_PARAM param;
	param.x = 100;
	param.y = 100;
	param.width = 100;
	param.height = 100;

	gl.Initialize(&param);
	gl.SetDisplayListBuffer(buf, buf_size);

	gl.ClearColor(argb);

	gxglutSetWindowTitle("MathColorUnitTest");

	gxglutDisplayFunc( displayFunc );

	gxglutMainLoop();
	delete [] buf;
#else
#endif
}

/**********************************************************************//**
 *
 * displayFunc
 *
*//***********************************************************************/
void displayFunc(void)
{
#if	defined(_IRIS_SUPPORT_OPENGL)
	COpenGL& gl = COpenGL::GetInstance();
	gl.Clear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);
	gl.SwapBuffers();
#endif
}


#endif
