//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathComplex.h
 * @brief		fZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathComplex_H_
#define INCG_IRIS_MathComplex_H_

//======================================================================
// include
#include "MathFpuDef.h"
#include "MathFpu.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFComplex*	FpuComplexSet(IrisFComplex* pc0, f32 re, f32 im);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexZero(IrisFComplex* pc0);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexAdd(IrisFComplex* pc0, const IrisFComplex* pc1, const IrisFComplex* pc2);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexSub(IrisFComplex* pc0, const IrisFComplex* pc1, const IrisFComplex* pc2);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexMul(IrisFComplex* pc0, const IrisFComplex* pc1, const IrisFComplex* pc2);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexDiv(IrisFComplex* pc0, const IrisFComplex* pc1, const IrisFComplex* pc2);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexAddReal(IrisFComplex* pc0, const IrisFComplex* pc1, f32 re);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexSubReal(IrisFComplex* pc0, const IrisFComplex* pc1, f32 re);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexMulReal(IrisFComplex* pc0, const IrisFComplex* pc1, f32 re);
IRIS_FPU_INLINE IrisFComplex*	FpuComplexDivReal(IrisFComplex* pc0, const IrisFComplex* pc1, f32 re);

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathComplex.inl"
#endif

#endif
