//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMatrix22.h
 * @brief		2x2}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathMatrix22_H_
#define INCG_IRIS_MathMatrix22_H_

//======================================================================
// include
#include "MathFpuDef.h"
#include "MathVector2.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Unit(IrisFMtx22* pm0);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Zero(IrisFMtx22* pm0);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Copy(IrisFMtx22* pm0, const IrisFMtx22* pm1);
IRIS_FPU_INLINE IrisFVec2*		FpuMtx22Transform(IrisFVec2* pv0, const IrisFMtx22* pm0, const IrisFVec2* pv1);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Mul(IrisFMtx22* pm0, const IrisFMtx22* pm1, const IrisFMtx22* pm2);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Scale(IrisFMtx22* pm0, const IrisFMtx22* pm1, f32 s);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Transpose(IrisFMtx22* pm0, const IrisFMtx22* pm1);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22RotZ(IrisFMtx22* pm0, const IrisFMtx22* pm1, f32 rz);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22RotIdxZ(IrisFMtx22* pm0, const IrisFMtx22* pm1, u16 idz);
IRIS_FPU_INLINE IrisBool		FpuMtx22IsUnit(const IrisFMtx22* pm0);
IRIS_FPU_INLINE f32				FpuMtx22Trace(const IrisFMtx22* pm0);
IRIS_FPU_INLINE f32				FpuMtx22Determinant(const IrisFMtx22* pm0);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22Adjoint(IrisFMtx22* pm0, const IrisFMtx22* pm1);
IRIS_FPU_INLINE IrisFMtx22*		FpuMtx22TruncatePrecision24(IrisFMtx22* pm0, const IrisFMtx22* pm1);

//======================================================================
// inline
STATICINLINE IrisFMtx22*	FpuMtx22Identity(IrisFMtx22* pm0)			{ return FpuMtx22Unit(pm0); }
STATICINLINE IrisFMtx22*	FpuMtx22Null(IrisFMtx22* pm0)				{ return FpuMtx22Zero(pm0); }
STATICINLINE IrisFVec2*	FpuMtx22Apply(IrisFVec2* pv0, const IrisFMtx22* pm0, const IrisFVec2* pv1)	{ return FpuMtx22Transform(pv0, pm0, pv1); }
STATICINLINE IrisBool		FpuMtx22IsIdentity(const IrisFMtx22* pm0)	{ return FpuMtx22IsUnit(pm0); }

}	// end of namespace math
}	// end of namespace iris


#ifdef _IRIS_FPU_INLINE
	#include "inl/MathMatrix22.inl"
#endif


#endif
