//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPlane.h
 * @brief		ʉZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPlane_H_
#define INCG_IRIS_MathPlane_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFPlane*		FpuPlaneSet(IrisFPlane* pl0, f32 a, f32 b, f32 c, f32 d);
IRIS_FPU_INLINE IrisFPlane*		FpuPlaneCopy(IrisFPlane* pl0, const IrisFPlane* pl1);
IRIS_FPU_INLINE IrisFPlane*		FpuPlaneAdd(IrisFPlane* pl0, const IrisFPlane* pl1, const IrisFPlane* pl2);
IRIS_FPU_INLINE IrisFPlane*		FpuPlaneSub(IrisFPlane* pl0, const IrisFPlane* pl1, const IrisFPlane* pl2);
IRIS_FPU_INLINE IrisFPlane*		FpuPlaneNormalize(IrisFPlane* pl0, const IrisFPlane* pl1);
IRIS_FPU_INLINE f32				FpuPlaneVec3Distance(const IrisFPlane* pl0, const IrisFVec3* pv0);
IRIS_FPU_INLINE f32				FpuPlaneVec4DistanceXYZ(const IrisFPlane* pl0, const IrisFVec4* pv0);

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathPlane.inl"
#endif

#endif
