//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathScalar.h
 * @brief		XJ[lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathScalar_H_
#define INCG_IRIS_MathScalar_H_

//======================================================================
// include
#include "MathFpu.h"
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE f32	FpuScalarAbs(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarAcos(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarAsin(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarAtan(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarAtan2(f32 y, f32 x);
IRIS_FPU_INLINE f32	FpuScalarCeil(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarCos(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarExp(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarFloor(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarLog(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarLog2(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarLog10(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarMax(f32 a, f32 b);
IRIS_FPU_INLINE f32	FpuScalarMin(f32 a, f32 b);
IRIS_FPU_INLINE f32	FpuScalarPow(f32 x, f32 y);
IRIS_FPU_INLINE f32	FpuScalarPow2(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarRound(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarRsqrt(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarSin(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarSqrt(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarTan(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarTrunc(f32 fs);
IRIS_FPU_INLINE f32	FpuScalarTruncatePrecision24(f32 fs);

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathScalar.inl"
#endif

#endif
