//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathVector3.h
 * @brief		3DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathVector3_H_
#define INCG_IRIS_MathVector3_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Set(IrisFVec3* pv0, f32 x, f32 y, f32 z);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Copy(IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3PositiveZero(IrisFVec3* pv0);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3NegativeZero(IrisFVec3* pv0);
IRIS_FPU_INLINE	IrisIVec3*	FpuVec3Ceil(IrisIVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisIVec3*	FpuVec3Trunc(IrisIVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisIVec3*	FpuVec3Round(IrisIVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisIVec3*	FpuVec3Floor(IrisIVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3FromIVec3(IrisFVec3* pv0, const IrisIVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Add(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Sub(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Mul(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Div(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Neg(IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Abs(IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Lerp(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2, f32 t);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Scale(IrisFVec3* pv0, const IrisFVec3* pv1, f32 s);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3ScaleAdd(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2, f32 s);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Hermite(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pt1
									  , const IrisFVec3* pv2, const IrisFVec3* pt2, f32 t);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Bezier(IrisFVec3* pv0, s32 n, const IrisFVec3* pva, f32 t);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Clamp(IrisFVec3* pv0, const IrisFVec3* pv1, f32 min, f32 max);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Max(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Min(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	f32		FpuVec3InnerProduct(const IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3OuterProduct(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	f32		FpuVec3Funnel(const IrisFVec3* pv0);
IRIS_FPU_INLINE	f32		FpuVec3Average(const IrisFVec3* pv0);
IRIS_FPU_INLINE	IrisBool	FpuVec3IsEqual(const IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisBool	FpuVec3IsZero(const IrisFVec3* pv0);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3SignFloat(IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisIVec3*	FpuVec3SignInt(IrisIVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Normalize(IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	f32		FpuVec3Length(const IrisFVec3* pv0);
IRIS_FPU_INLINE	f32		FpuVec3Distance(const IrisFVec3* pv0, const IrisFVec3* pv1);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3FaceForward(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2, const IrisFVec3* pv3);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Reflect(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3Refract(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2, f32 eta);
IRIS_FPU_INLINE	IrisFVec3*	FpuVec3TruncatePrecision24(IrisFVec3* pv0, const IrisFVec3* pv1);

//======================================================================
// inline function
STATICINLINE IrisFVec3*	FpuVec3Null(IrisFVec3* pv0)	{ return FpuVec3PositiveZero(pv0); }
STATICINLINE IrisFVec3*	FpuVec3Zero(IrisFVec3* pv0)	{ return FpuVec3PositiveZero(pv0); }
STATICINLINE f32		FpuVec3Dot(const IrisFVec3* pv0, const IrisFVec3* pv1)						{ return FpuVec3InnerProduct(pv0, pv1); }
STATICINLINE IrisFVec3*	FpuVec3Cross(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2)		{ return FpuVec3OuterProduct(pv0, pv1, pv2); }
STATICINLINE IrisFVec3*	FpuVec3Subtract(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2)	{ return FpuVec3Sub(pv0, pv1, pv2); }
STATICINLINE IrisFVec3*	FpuVec3Multiply(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2)	{ return FpuVec3Mul(pv0, pv1, pv2); }
STATICINLINE IrisFVec3*	FpuVec3Divide(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2)	{ return FpuVec3Div(pv0, pv1, pv2); }
STATICINLINE IrisFVec3*	FpuVec3Inter(IrisFVec3* pv0, const IrisFVec3* pv1, const IrisFVec3* pv2, f32 t)	{ return FpuVec3Lerp(pv0, pv1, pv2, t); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathVector3.inl"
#endif

#endif
