//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathScalar.inl
 * @brief		XJ[lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathScalar_inl_
#define INCG_IRIS_MathScalar_inl_

namespace iris {
namespace math
{

//======================================================================
// function
/**
 * @brief	_̐ΒlԂ
 * @param [in]	fs	= l
 * @return	Βl
*/
IRIS_FPU_INLINE f32	FpuScalarAbs(f32 fs)
{
	return F32_Abs(fs);
}

/**
 * @brief	t](A[NRTC)vZ
 * @param [in]	fs	= l
 * @return	t]
*/
IRIS_FPU_INLINE f32	FpuScalarAcos(f32 fs)
{
	return F32_Acos(fs);
}

/**
 * @brief	t(A[NTC)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_FPU_INLINE f32	FpuScalarAsin(f32 fs)
{
	return F32_Asin(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	fs	= l
 * @return	t
*/
IRIS_FPU_INLINE f32	FpuScalarAtan(f32 fs)
{
	return F32_Atan(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	y	= yl
 * @param [in]	x	= xl
 * @return	t
*/
IRIS_FPU_INLINE f32	FpuScalarAtan2(f32 y, f32 x)
{
	return F32_Atan2(y, x);
}

/**
 * @brief	XJ[l̐؂グ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarCeil(f32 fs)
{
	return F32_Ceil(fs);
}

/**
 * @brief	](RTC)vZ
 * @param [in]	fs	= WAl
 * @return	]
*/
IRIS_FPU_INLINE f32	FpuScalarCos(f32 fs)
{
	return F32_Cos(fs);
}

/**
 * @brief	eƂw
 * @param [in]	fs	= l
 * @return	eƂw
*/
IRIS_FPU_INLINE f32	FpuScalarExp(f32 fs)
{
	return F32_Exp(fs);
}

/**
 * @brief	XJ[l̐؂̂
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarFloor(f32 fs)
{
	return F32_Floor(fs);
}

/**
 * @brief	Rΐ
 * @param [in]	fs	= l
 * @return	Rΐ
*/
IRIS_FPU_INLINE f32	FpuScalarLog(f32 fs)
{
	return F32_Log(fs);
}

/**
 * @brief	2Ƃΐ
 * @param [in]	fs	= l
 * @return	2Ƃΐ
*/
IRIS_FPU_INLINE f32	FpuScalarLog2(f32 fs)
{
	return F32_Log2(fs);
}

/**
 * @brief	pΐ
 * @param [in]	fs	= l
 * @return	pΐ
*/
IRIS_FPU_INLINE f32	FpuScalarLog10(f32 fs)
{
	return F32_Log10(fs);
}

/**
 * @brief	XJ[ől
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ől
*/
IRIS_FPU_INLINE f32	FpuScalarMax(f32 a, f32 b)
{
	return (a > b) ? a : b;
}

/**
 * @brief	XJ[ŏl
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ŏl
*/
IRIS_FPU_INLINE f32	FpuScalarMin(f32 a, f32 b)
{
	return (a < b) ? a : b;
}

/**
 * @brief	w
 * @param [in]	x	= l
 * @param [in]	y	= l
 * @return	w
*/
IRIS_FPU_INLINE f32	FpuScalarPow(f32 x, f32 y)
{
	return F32_Pow(x, y);
}

/**
 * @brief	2Ƃw
 * @param [in]	fs	= l
 * @return	w
*/
IRIS_FPU_INLINE f32	FpuScalarPow2(f32 fs)
{
	return F32_Pow2(fs);
}

/**
 * @brief	ߖTۂ(ľܓ)
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarRound(f32 fs)
{
	return F32_Round(fs);
}

/**
 * @brief	̋t
 * @param [in]	fs	= l
 * @return	̋t
*/
IRIS_FPU_INLINE f32	FpuScalarRsqrt(f32 fs)
{
	return F32_Rsqrt(fs);
}

/**
 * @brief	(TC)
 * @param [in]	fs	= WAl
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarSin(f32 fs)
{
	return F32_Sin(fs);
}

/**
 * @brief	
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarSqrt(f32 fs)
{
	return F32_Sqrt(fs);
}

/**
 * @brief	(^WFg)
 * @param [in]	fs	= WAl
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarTan(f32 fs)
{
	return F32_Tan(fs);
}

/**
 * @brief	0ۂ
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarTrunc(f32 fs)
{
	return F32_Trunc(fs);
}

/**
 * @brief	̉8rbg̐x؂̂
 * @param [in]	fs	= l
 * @return	
*/
IRIS_FPU_INLINE f32	FpuScalarTruncatePrecision24(f32 fs)
{
	IrisFInt v = fs;
	v.iv &= 0xFFFFFF00;
	return v.fv;
}

}	// end of namespace math
}	// end of namespace iris

#endif
