//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMD5.h
 * @brief		MD5 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathMD5_H_
#define INCG_IRIS_MathMD5_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// const
//! nbVTCY
static const int MD5HASHSIZE = 16;

//======================================================================
// struct
//! MD5pReLXg
typedef struct tagMD5CONTEXT
{
	u32	uState[4];		//!< ABCD
	u32	uCount[2];		//!< count
	u8	uBuffer[64];	//!< obt@
} MD5CONTEXT, *LPMD5CONTEXT;	//!< MD5pReLXg
typedef const MD5CONTEXT	*LPCMD5CONTEXT;

//! MD5nbVo͌^
typedef struct tagMD5DIGEST
{
	u8	hash[MD5HASHSIZE];		//!< obt@
} MD5DIGEST, LPMD5DIGEST;	//!< MD5nbVo͌^

//======================================================================
// function
// MD5pReLXg̏
void	MD5InitContext(LPMD5CONTEXT lpContext);
// MD5pReLXg̃NA
void	MD5ClearContext(LPMD5CONTEXT lpContext);
// MD5vZ
void	MD5Update(LPMD5CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// ŏIIMD5vZ
void	MD5Final(LPMD5CONTEXT lpContext);
// MD5o
void	MD5Output(LPCMD5CONTEXT lpContext, u8* lpBuffer);

// MD5܂Ƃ߂ČvZ
void	MD5Encode(LPMD5CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
void	MD5Encode(u8* lpDst, const u8* lpBuffer, size_t uLength);

// MD5o͒l𕶎ɕϊ
LPTSTR	MD5ToString (LPTSTR lpString, size_t uSize, const u8* lpMD5);
LPSTR	MD5ToStringA(LPSTR  lpString, size_t uSize, const u8* lpMD5);
LPWSTR	MD5ToStringW(LPWSTR lpString, size_t uSize, const u8* lpMD5);


// template
/**
 * @brief	MD5vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	MD5Update(LPMD5CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	MD5Update(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	MD5܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	MD5Encode(LPMD5CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	MD5Encode(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	MD5܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	MD5Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	MD5Encode(lpDst, pointer_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
