//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA1.h
 * @brief		SHA1 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA1_H_
#define INCG_IRIS_MathSHA1_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// const
//! SHA1nbVTCY
static const int SHA1_HASHSIZE_IN	= 20;
//! SHA1nbVTCY
static const int SHA1_HASHSIZE		= 20;
//! SHA1bZ[Wobt@TCY
static const int SHA1_LENGTHBUFSIZE	= 8;
//! SHA1bZ[WubNTCY
static const int SHA1_MSGBLKSIZE	= 64;

//======================================================================
// struct
//! SHA1pReLXg
typedef struct tagSHA1CONTEXT
{
	u32	uState[SHA1_HASHSIZE_IN>>2];	//!< nbV
	u32 uCount[SHA1_LENGTHBUFSIZE>>2];	//!< bZ[W
	u16	uIndex;							//!< obt@CfbNX
	u8	uBuffer[SHA1_MSGBLKSIZE];		//!< bZ[WubN
} SHA1CONTEXT, *LPSHA1CONTEXT;	//!< SHA1pReLXg
typedef const SHA1CONTEXT	*LPCSHA1CONTEXT;

//! SHA1nbVo͌^
typedef struct tagSHA1DIGEST
{
	u8	hash[SHA1_HASHSIZE];		//!< obt@
} SHA1DIGEST, LPSHA1DIGEST;	//!< SHA1nbVo͌^

//======================================================================
// function
// SHA1pReLXg̏
void	SHA1InitContext(LPSHA1CONTEXT lpContext);
// SHA1pReLXg̃NA
void	SHA1ClearContext(LPSHA1CONTEXT lpContext);
// SHA1vZ
void	SHA1Update(LPSHA1CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// ŏIISHA1vZ
void	SHA1Final(LPSHA1CONTEXT lpContext);
// SHA1o
void	SHA1Output(LPCSHA1CONTEXT lpContext, u8* lpBuffer);

// SHA1܂Ƃ߂ČvZ
void	SHA1Encode(LPSHA1CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
void	SHA1Encode(u8* lpDst, const u8* lpBuffer, size_t uLength);

// SHA1o͒l𕶎ɕϊ
LPTSTR	SHA1ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA1);
LPSTR	SHA1ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA1);
LPWSTR	SHA1ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA1);


// template
/**
 * @brief	SHA1vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA1Update(LPSHA1CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA1Update(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA1܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA1Encode(LPSHA1CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA1Encode(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA1܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA1Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA1Encode(lpDst, pointer_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
