//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA160.h
 * @brief		SHA160 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA160_H_
#define INCG_IRIS_MathSHA160_H_

//======================================================================
// include
#include "MathSHA1.h"

namespace iris {
namespace math
{

//======================================================================
// define
//! SHA160nbVTCY
static const int SHA160_HASHSIZE_IN		= SHA1_HASHSIZE_IN;
//! SHA160nbVTCY
static const int SHA160_HASHSIZE		= SHA1_HASHSIZE;
//! SHA160bZ[Wobt@TCY
static const int SHA160_LENGTHBUFSIZE	= SHA1_LENGTHBUFSIZE;
//! SHA160bZ[WubNTCY
static const int SHA160_MSGBLKSIZE		= SHA1_MSGBLKSIZE;

//======================================================================
// struct
typedef SHA1CONTEXT		SHA160CONTEXT;		//!< SHA160pReLXg
typedef LPSHA1CONTEXT	LPSHA160CONTEXT;	//!< SHA160pReLXg|C^[^
typedef LPCSHA1CONTEXT	LPCSHA160CONTEXT;	//!< SHA160pReLXg|C^[^

typedef SHA1DIGEST		SHA160DIGEST;			//!< SHA160nbVo͌^
typedef SHA1DIGEST		*LPSHA160DIGEST;		//!< SHA160nbVo̓|C^[^

//======================================================================
// function
/**
 * @brief	SHA160pReLXg̏
 * @note	iris::math::SHA1InitContext
*/
STATICINLINE	void	SHA160InitContext(LPSHA160CONTEXT lpContext)
{
	SHA1InitContext(lpContext);
}
/**
 * @brief	SHA160pReLXg̃NA
 * @note	iris::math::SHA1ClearContext
*/
STATICINLINE	void	SHA160ClearContext(LPSHA160CONTEXT lpContext)
{
	SHA1ClearContext(lpContext);
}
/**
 * @brief	SHA160vZ
 * @note	iris::math::SHA1Update
*/
STATICINLINE	void	SHA160Update(LPSHA160CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA1Update(lpContext, lpBuffer, uLength);
}
/**
 * @brief	ŏIISHA160vZ
 * @note	iris::math::SHA1Final
*/
STATICINLINE	void	SHA160Final(LPSHA160CONTEXT lpContext)
{
	SHA1Final(lpContext);
}
/**
 * @brief	SHA160o
 * @note	iris::math::SHA1Output
*/
STATICINLINE	void	SHA160Output(LPCSHA160CONTEXT lpContext, u8* lpBuffer)
{
	SHA1Output(lpContext, lpBuffer);
}

/**
 * @brief	SHA160܂Ƃ߂ČvZ
 * @note	iris::math::SHA1Encode
*/
STATICINLINE	void	SHA160Encode(LPSHA160CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA1Encode(lpContext, lpBuffer, uLength);
}
/**
 * @brief	SHA160܂Ƃ߂ČvZ
 * @note	iris::math::SHA1Encode
*/
STATICINLINE	void	SHA160Encode(u8* lpDst, const u8* lpBuffer, size_t uLength)
{
	SHA1Encode(lpDst, lpBuffer, uLength);
}

/**
 * @brief	SHA160o͒l𕶎ɕϊ
 * @note	iris::math::SHA1ToString
*/
STATICINLINE	LPTSTR	SHA160ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA160)
{
	return SHA1ToString (lpString, uSize, lpSHA160);
}
STATICINLINE	LPSTR	SHA160ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA160)
{
	return SHA1ToStringA(lpString, uSize, lpSHA160);
}
STATICINLINE	LPWSTR	SHA160ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA160)
{
	return SHA1ToStringW(lpString, uSize, lpSHA160);
}


// template
/**
 * @brief	SHA160vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA160Update(LPSHA160CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA1Update(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA160܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA160Encode(LPSHA160CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA1Encode(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA160܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA160Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA1Encode(lpDst, pointer_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
