//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA224.cpp
 * @brief		SHA224 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathSHA224_CPP_
#define INCG_IRIS_MathSHAPrivate_CPP_	// private֐gp

//======================================================================
// include
#include "MathSHA224.h"
#include "MathSHACommon.h"
#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// function
/**********************************************************************//**
 *
 * SHA224pReLXg̏
 *
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	SHA224InitContext(LPSHA224CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	lpContext->uCount[0] = lpContext->uCount[1] = 0;
	lpContext->uIndex = 0;
	lpContext->uState[0] = 0xC1059ED8;
	lpContext->uState[1] = 0x367CD507;
	lpContext->uState[2] = 0x3070DD17;
	lpContext->uState[3] = 0xF70E5939;
	lpContext->uState[4] = 0xFFC00B31;
	lpContext->uState[5] = 0x68581511;
	lpContext->uState[6] = 0x64F98FA7;
	lpContext->uState[7] = 0xBEFA4FA4;
	//ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * SHA224pReLXg̃NA
 *
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	SHA224ClearContext(LPSHA224CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	SHA224InitContext(lpContext);
	ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * SHA224o
 *
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void	SHA224Output(LPCSHA224CONTEXT lpContext, u8* lpBuffer)
{
	_SHAEncode32(lpBuffer, lpContext->uState, SHA224_HASHSIZE);
}

/**********************************************************************//**
 *
 * SHA224܂Ƃ߂ČvZ(Init ` Final)
 *
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	SHA224Encode(LPSHA224CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA224InitContext(lpContext);
	SHA224Update(lpContext, lpBuffer, uLength);
	SHA224Final(lpContext);
}

/**********************************************************************//**
 *
 * SHA224܂Ƃ߂ČvZ(Init ` Output)
 *
 ----------------------------------------------------------------------
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	SHA224Encode(u8* lpDst, const u8* lpBuffer, size_t uLength)
{
	SHA224CONTEXT ctx;
	SHA224InitContext(&ctx);
	SHA224Update(&ctx, lpBuffer, uLength);
	SHA224Final(&ctx);
	SHA224Output(&ctx, lpDst);
}

/**********************************************************************//**
 *
 * SHA224o͒l𕶎ɕϊ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpSHA224	= ̓obt@(SHA224)
*//***********************************************************************/
LPTSTR	SHA224ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA224)
{
	return SHAToString(lpString, uSize, lpSHA224, SHA224_HASHSIZE);
}
LPSTR	SHA224ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA224)
{
	return SHAToStringA(lpString, uSize, lpSHA224, SHA224_HASHSIZE);
}
LPWSTR	SHA224ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA224)
{
	return SHAToStringW(lpString, uSize, lpSHA224, SHA224_HASHSIZE);
}

}	// end of namespace math
}	// end of namespace iris


#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CMathSHA224Test, Function)
{
	char comm[256] = "";
	u8 out[SHA224_HASHSIZE];

	SHA224CONTEXT ctx;

	// TEST1
	strcpy_s(comm, 256, "abc");
	SHA224Encode(out, comm, strlen(comm));
	SHA224ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq");
	SHA224Encode(out, comm, strlen(comm));
	SHA224ToStringA(comm, 256, out);
	ASSERT_STREQ(
        "75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	SHA224InitContext(&ctx);
	for( int i=0; i < 1000000; ++i )
		SHA224Update(&ctx, comm, strlen(comm));
	SHA224Final(&ctx);
	SHA224Output(&ctx, out);
	SHA224ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	SHA224InitContext(&ctx);
	for( int i=0; i < 10; ++i )
		SHA224Update(&ctx, comm, strlen(comm));
	SHA224Final(&ctx);
	SHA224Output(&ctx, out);
	SHA224ToStringA(comm, 256, out);
	ASSERT_STREQ(
		"567f69f168cd7844e65259ce658fe7aadfa25216e68eca0eb7ab8262"
		, comm );
}

#endif

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathSHA224UnitTest, Func)
{
	char comm[256] = "";
	u8 out[SHA224_HASHSIZE];

	std::clog << "SHA224GR[h܂B" << std::endl;
	std::safe_cin >> comm;

	SHA224Encode(out, comm, strlen(comm));

	for( int i=0; i < SHA224_HASHSIZE; ++i )
		printf("%.2x", out[i]);
	std::cout << std::endl;
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
