//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA256.h
 * @brief		SHA256 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA256_H_
#define INCG_IRIS_MathSHA256_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// define
//! SHA256nbVTCY
static const int SHA256_HASHSIZE_IN		= 32;
//! SHA256nbVTCY
static const int SHA256_HASHSIZE		= 32;
//! SHA256bZ[Wobt@TCY
static const int SHA256_LENGTHBUFSIZE	= 8;
//! SHA256bZ[WubNTCY
static const int SHA256_MSGBLKSIZE		= 64;

//======================================================================
// struct
//! SHA256pReLXg
typedef struct tagSHA256CONTEXT
{
	u32	uState[SHA256_HASHSIZE_IN>>2];		//!< nbV
	u32 uCount[SHA256_LENGTHBUFSIZE>>2];	//!< bZ[W
	u16	uIndex;								//!< obt@CfbNX
	u8	uBuffer[SHA256_MSGBLKSIZE];			//!< bZ[WubN
} SHA256CONTEXT, *LPSHA256CONTEXT;			//!< SHA256pReLXg
typedef const SHA256CONTEXT	*LPCSHA256CONTEXT;

//! SHA256nbVo͌^
typedef struct tagSHA256DIGEST
{
	u8	hash[SHA256_HASHSIZE];		//!< obt@
} SHA256DIGEST, LPSHA256DIGEST;	//!< SHA256nbVo͌^

//======================================================================
// function
// SHA256pReLXg̏
void	SHA256InitContext(LPSHA256CONTEXT lpContext);
// SHA256pReLXg̃NA
void	SHA256ClearContext(LPSHA256CONTEXT lpContext);
// SHA256vZ
void	SHA256Update(LPSHA256CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// ŏIISHA256vZ
void	SHA256Final(LPSHA256CONTEXT lpContext);
// SHA256o
void	SHA256Output(LPCSHA256CONTEXT lpContext, u8* lpBuffer);

// SHA256܂Ƃ߂ČvZ
void	SHA256Encode(LPSHA256CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
void	SHA256Encode(u8* lpDst, const u8* lpBuffer, size_t uLength);

// SHA256o͒l𕶎ɕϊ
LPTSTR	SHA256ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA256);
LPSTR	SHA256ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA256);
LPWSTR	SHA256ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA256);


// template
/**
 * @brief	SHA256vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA256Update(LPSHA256CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA256Update(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA256܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA256Encode(LPSHA256CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA256Encode(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA256܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA256Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA256Encode(lpDst, pointer_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
