//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPrimeEratosthenes.cpp
 * @brief		MathPrimeEratosthenes t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathPrimeEratosthenes_CPP_

//======================================================================
// include
#include "MathPrimeEratosthenes.h"
#include "../../iris_debug.h"

#ifdef _IRIS_DEBUGTEST_ENABLE
#include "../../xpi/os/XpiSysTime.h"
#define START_STOPWATCH(n)		u64	tick0##n = xpi::CSysTick::GetTick()
#define STOP_STOPWATCH(n)		u64	tick1##n = xpi::CSysTick::GetTick()
#define DUMP_STOPWATCH(n, msg)	printf(msg "%f sec.\n", xpi::CSysTick::TicksToMilliSeconds(xpi::CSysTick::DiffTick(tick1##n, tick0##n))/1000.0f)
#else
#define START_STOPWATCH(n)		(void)0
#define STOP_STOPWATCH(n)		(void)0
#define DUMP_STOPWATCH(n, msg)	(void)0
#endif

namespace iris {
namespace math
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPrimeEratosthenes::CPrimeEratosthenes(void)
: m_Max(0)
{
	IRIS_STATIC_ASSERT( OPTIMIZE > 0 && OPTIMIZE <= 5 );
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPrimeEratosthenes::~CPrimeEratosthenes(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPrimeEratosthenes::Initialize(void)
{
	Clear();
	if( m_Primes.empty() )
	{
		m_Primes.push_back(2);
		m_Primes.push_back(3);
		m_Primes.push_back(5);
		m_Primes.push_back(7);
		m_Primes.push_back(11);
		m_Max = 12;
	}
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPrimeEratosthenes::Initialize(const list_type& def)
{
	if( def.empty() )
	{
		Initialize();
		return;
	}
	Clear();
	m_Primes = def;
	m_Max = def.back();
	m_Max = (m_Max + 1) & ~((value_type)1);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CPrimeEratosthenes::Clear(void)
{
	m_Primes.clear();
	m_Max = 0;
}

/**********************************************************************//**
 *
 * w̐l܂ł̑fXgAbv
 *
 -----------------------------------------------------------------------
 * @param [in]	uMax	= ől
*//***********************************************************************/
void CPrimeEratosthenes::Listup(value_type uMax)
{
	IRIS_ASSERT( (m_Max & 1) == 0 );
	const value_type begin = m_Max;
	if( uMax <= begin ) return;	// XgAbvς
	list_type stock;

	START_STOPWATCH(0);

	switch( OPTIMIZE )
	{
	case 1:
		{
			for(value_type i=begin | 1; i <= uMax; i+=2)
			{
				stock.push_back(i);
			}
		}
		break;
	case 2:
		{
			static const value_type lcm = 2*3;
			const value_type s = begin/lcm;
			const value_type e = uMax/lcm;
			const value_type uStart = s*lcm;
			const value_type uEndMax = e*lcm;

			if( uStart+5 > begin && uStart+5 <= uMax )
			{
				if( uStart+1 > begin ) stock.push_back(uStart+1);
				stock.push_back(uStart+5);
			}

			for( value_type i=uStart+lcm+1; i < uEndMax; i+=lcm )
			{
				stock.push_back(i);
				stock.push_back(i+4);
			}

			if( uEndMax+1 <= uMax && uEndMax+1 > begin )
			{
				stock.push_back(uEndMax+1);
				if( uEndMax+5 <= uMax ) stock.push_back(uEndMax+5);
			}
		}
		break;
	case 3:
		{
			static const value_type lcm = 2*3*5;
			const value_type s = begin/lcm;
			const value_type e = uMax/lcm;
			const value_type uStart = s*lcm;
			const value_type uEndMax = e*lcm;

			// 1, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 
			if( uStart+ 1 > begin && uStart+ 1 <= uMax )	stock.push_back(uStart+ 1);
			if( uStart+ 7 > begin && uStart+ 7 <= uMax )	stock.push_back(uStart+ 7);
			if( uStart+11 > begin && uStart+11 <= uMax )	stock.push_back(uStart+11);
			if( uStart+13 > begin && uStart+13 <= uMax )	stock.push_back(uStart+13);
			if( uStart+17 > begin && uStart+17 <= uMax )	stock.push_back(uStart+17);
			if( uStart+19 > begin && uStart+19 <= uMax )	stock.push_back(uStart+19);
			if( uStart+23 > begin && uStart+23 <= uMax )	stock.push_back(uStart+23);
			if( uStart+29 > begin && uStart+29 <= uMax )	stock.push_back(uStart+29);

			for( value_type i=uStart+lcm; i < uEndMax; i+=lcm )
			{
				stock.push_back(i+ 1);
				stock.push_back(i+ 7);
				stock.push_back(i+11);
				stock.push_back(i+13);
				stock.push_back(i+17);
				stock.push_back(i+19);
				stock.push_back(i+23);
				stock.push_back(i+29);
			}

			if( uEndMax+1 <= uMax && uEndMax+1 > begin )
			{
				stock.push_back(uEndMax+1);
				// ܂c
				if( uEndMax+ 7 <= uMax ) stock.push_back(uEndMax+ 7);
				if( uEndMax+11 <= uMax ) stock.push_back(uEndMax+11);
				if( uEndMax+13 <= uMax ) stock.push_back(uEndMax+13);
				if( uEndMax+17 <= uMax ) stock.push_back(uEndMax+17);
				if( uEndMax+19 <= uMax ) stock.push_back(uEndMax+19);
				if( uEndMax+23 <= uMax ) stock.push_back(uEndMax+23);
				if( uEndMax+29 <= uMax ) stock.push_back(uEndMax+29);
			}
		}
		break;
	case 4:
		{
			static const value_type lcm = 2*3*5*7;
			const value_type s = begin/lcm;
			const value_type e = uMax/lcm;
			const value_type uStart = s*lcm;
			const value_type uEndMax = e*lcm;

			// [1, lcm] ̐l 2, 3, 5, 7 Ŋ؂Ȃ
			const value_type sieve[] = {
				1, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43
				, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97
				, 101, 103, 107, 109, 113, 121, 127, 131, 137
				, 139, 143, 149, 151, 157, 163, 167, 169, 173
				, 179, 181, 187, 191, 193, 197, 199, 209
			};
			for( int k=0; k < elementof(sieve); ++k )
			{
				const value_type v = uStart + sieve[k];
				if( v > begin && v <= uMax )	stock.push_back(v);
			}

			for( value_type i=uStart+lcm; i < uEndMax; i+=lcm )
			{
				for( int k=0; k < elementof(sieve); ++k )
				{
					stock.push_back(i+sieve[k]);
				}
			}

			for( int k=0; k < elementof(sieve); ++k )
			{
				const value_type v = uEndMax + sieve[k];
				if( v > begin && v <= uMax )	stock.push_back(v);
			}
		}
		break;
	case 5:
		{
			static const value_type lcm = 2*3*5*7*11;
			const value_type s = begin/lcm;
			const value_type e = uMax/lcm;
			const value_type uStart = s*lcm;
			const value_type uEndMax = e*lcm;

			// [1, lcm] ̐l 2, 3, 5, 7 Ŋ؂Ȃ
			const value_type sieve[] = {
				1, 13, 17, 19, 23, 29, 31, 37
				, 41, 43, 47, 53, 59, 61, 67, 71
				, 73, 79, 83, 89, 97, 101, 103, 107
				, 109, 113, 127, 131, 137, 139, 149, 151
				, 157, 163, 167, 169, 173, 179, 181, 191
				, 193, 197, 199, 211, 221, 223, 227, 229
				, 233, 239, 241, 247, 251, 257, 263, 269
				, 271, 277, 281, 283, 289, 293, 299, 307
				, 311, 313, 317, 323, 331, 337, 347, 349
				, 353, 359, 361, 367, 373, 377, 379, 383
				, 389, 391, 397, 401, 403, 409, 419, 421
				, 431, 433, 437, 439, 443, 449, 457, 461
				, 463, 467, 479, 481, 487, 491, 493, 499
				, 503, 509, 521, 523, 527, 529, 533, 541
				, 547, 551, 557, 559, 563, 569, 571, 577
				, 587, 589, 593, 599, 601, 607, 611, 613
				, 617, 619, 629, 631, 641, 643, 647, 653
				, 659, 661, 667, 673, 677, 683, 689, 691
				, 697, 701, 703, 709, 713, 719, 727, 731
				, 733, 739, 743, 751, 757, 761, 767, 769
				, 773, 779, 787, 793, 797, 799, 809, 811
				, 817, 821, 823, 827, 829, 839, 841, 851
				, 853, 857, 859, 863, 871, 877, 881, 883
				, 887, 893, 899, 901, 907, 911, 919, 923
				, 929, 937, 941, 943, 947, 949, 953, 961
				, 967, 971, 977, 983, 989, 991, 997, 1003
				, 1007, 1009, 1013, 1019, 1021, 1027, 1031, 1033
				, 1037, 1039, 1049, 1051, 1061, 1063, 1069, 1073
				, 1079, 1081, 1087, 1091, 1093, 1097, 1103, 1109
				, 1117, 1121, 1123, 1129, 1139, 1147, 1151, 1153
				, 1157, 1159, 1163, 1171, 1181, 1187, 1189, 1193
				, 1201, 1207, 1213, 1217, 1219, 1223, 1229, 1231
				, 1237, 1241, 1247, 1249, 1259, 1261, 1271, 1273
				, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303
				, 1307, 1313, 1319, 1321, 1327, 1333, 1339, 1343
				, 1349, 1357, 1361, 1363, 1367, 1369, 1373, 1381
				, 1387, 1391, 1399, 1403, 1409, 1411, 1417, 1423
				, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1457
				, 1459, 1469, 1471, 1481, 1483, 1487, 1489, 1493
				, 1499, 1501, 1511, 1513, 1517, 1523, 1531, 1537
				, 1541, 1543, 1549, 1553, 1559, 1567, 1571, 1577
				, 1579, 1583, 1591, 1597, 1601, 1607, 1609, 1613
				, 1619, 1621, 1627, 1633, 1637, 1643, 1649, 1651
				, 1657, 1663, 1667, 1669, 1679, 1681, 1691, 1693
				, 1697, 1699, 1703, 1709, 1711, 1717, 1721, 1723
				, 1733, 1739, 1741, 1747, 1751, 1753, 1759, 1763
				, 1769, 1777, 1781, 1783, 1787, 1789, 1801, 1807
				, 1811, 1817, 1819, 1823, 1829, 1831, 1843, 1847
				, 1849, 1853, 1861, 1867, 1871, 1873, 1877, 1879
				, 1889, 1891, 1901, 1907, 1909, 1913, 1919, 1921
				, 1927, 1931, 1933, 1937, 1943, 1949, 1951, 1957
				, 1961, 1963, 1973, 1979, 1987, 1993, 1997, 1999
				, 2003, 2011, 2017, 2021, 2027, 2029, 2033, 2039
				, 2041, 2047, 2053, 2059, 2063, 2069, 2071, 2077
				, 2081, 2083, 2087, 2089, 2099, 2111, 2113, 2117
				, 2119, 2129, 2131, 2137, 2141, 2143, 2147, 2153
				, 2159, 2161, 2171, 2173, 2179, 2183, 2197, 2201
				, 2203, 2207, 2209, 2213, 2221, 2227, 2231, 2237
				, 2239, 2243, 2249, 2251, 2257, 2263, 2267, 2269
				, 2273, 2279, 2281, 2287, 2291, 2293, 2297, 2309
			};
			for( int k=0; k < elementof(sieve); ++k )
			{
				const value_type v = uStart + sieve[k];
				if( v > begin && v <= uMax )	stock.push_back(v);
			}

			for( value_type i=uStart+lcm; i < uEndMax; i+=lcm )
			{
				for( int k=0; k < elementof(sieve); ++k )
				{
					stock.push_back(i+sieve[k]);
				}
			}

			for( int k=0; k < elementof(sieve); ++k )
			{
				const value_type v = uEndMax + sieve[k];
				if( v > begin && v <= uMax )	stock.push_back(v);
			}
		}
		break;
	}

	STOP_STOPWATCH(0);
	DUMP_STOPWATCH(0, "listup ");

	START_STOPWATCH(1);

	list_type work;

#if 0
#if 0
	list_type::const_iterator prime_it = m_Primes.begin();
	for( int i=0; i < OPTIMIZE; ++i ) ++prime_it;
	for( ; prime_it != m_Primes.end(); ++prime_it )
	{
		const value_type tmp = *prime_it;
#else
	for( size_t i=0, size=m_Primes.size(); i < size; ++i )
	{
		const value_type tmp = m_Primes[i];
#endif
		const value_type sq = tmp*tmp;
		for( list_type::const_iterator it=stock.begin(); it != stock.end(); )
		{
			const value_type v = *it;
			if( v % tmp )
			{
				if( v > sq )
				{
					++it;	// ܂m肵ȂB
					continue;
				}
				work.push_back(v);	// fƊm肵
			}
			it = stock.erase(it);
		}
	}
#else
	for( list_type::iterator it=stock.begin(); it != stock.end(); )
	{
		const value_type v = *it;
		list_type::iterator prev = it;
		++it;
		for( size_t i=0, size=m_Primes.size(); i < size; ++i )
		{
			const value_type tmp = m_Primes[i];
			const value_type sq = tmp*tmp;
			if( v % tmp )
			{
				if( v > sq ) continue;
				work.push_back(v);	// fƊm肵
			}
			it = stock.erase(prev);
			break;
		}
	}
#endif

	STOP_STOPWATCH(1);
	DUMP_STOPWATCH(1, "step0 ");

	START_STOPWATCH(2);

	while(!stock.empty())
	{
		value_type tmp=0;
		// step 1
		// TXg̐擪fXgɈړ
		{
			if( work.empty() )
			{
				tmp = stock[0];
				stock.erase(stock.begin());
			}
			else
			{
				tmp = work[0];
				work.erase(work.begin());
			}
			m_Primes.push_back(tmp);
		}

#if 0
		// step 2
		{
			// step 1̐̔{TXg폜
			for( list_type::const_iterator it = stock.begin(); it != stock.end(); )
			{
				if( (*it % tmp) == 0 )
				{
					it = stock.erase(it);
					continue;
				}
				++it;
			}
		}

		// step 3
		{
			value_type sq = tmp*tmp;
			for( list_type::const_iterator it = stock.begin(); it != stock.end(); )
			{
				value_type v = *it;
				if( v >= sq ) break;
				work.push_back(v);
				it = stock.erase(it);
			}
		}
#else
		// step 2 3
		{
			// step 1̐̔{TXg폜ȂA2肿l͌ɓ
			value_type sq = tmp*tmp;
			list_type::iterator it = stock.begin();
			for( ; it != stock.end(); )
			{
				const value_type v = *it;
				if( v > sq ) break;

				it = stock.erase(it);
				if( (v % tmp) == 0 ) continue;
				work.push_back(v);
			}

			// step 1̐̔{TXg폜
			for( ; it != stock.end(); )
			{
				if( (*it % tmp) == 0 )
				{
					it = stock.erase(it);
					continue;
				}
				++it;
			}
		}

#endif
	}

	for( size_t i=0, size=work.size(); i < size; ++i )
	{
		m_Primes.push_back(work[i]);
	}

	STOP_STOPWATCH(2);
	DUMP_STOPWATCH(2, "eratosthenes ");

	m_Max = (uMax + 1) & ~((value_type)1);
}

}	// end of namespace math
}	// end of namespace iris

