//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndDistribution.h
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_RndDistribution_H_
#define INCG_IRIS_RndDistribution_H_

//======================================================================
// include
#include "RndBase.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class
/// zNX
class CDistribution : public IRand
{
protected:
	IRand*	m_pGenerator;	//!< WFl[^[
public:
	// RXgN^
	CDistribution(void);
	CDistribution(IRand* pGen);

public:
	/// ̐ݒ
	void	SetGenerator(IRand* pGen)	{ m_pGenerator = pGen; }
	/// ̎擾
	IRand*	GetGenerator(void)			{ return m_pGenerator; }

public:
	// ̐ݒ
	virtual void	SetSeed(u32 seed);
public:
	// 32bit ̐
	virtual u32		GenRand32(void);

public:
	// Rx˂̃JCQ敪z
	f32		Chisq(f32 n);
	// p[^̃K}z
	f32		Gamma(f32 a);
	// mo̊􉽕z
	s32		Geometric(f32 p);
	// Opz
	f32		Triangle(void);
	// ςP̎wz
	f32		Exp(void);
	// WKz
	f32		Normal(void);
	// m̃_PʃxNg
	void	UnitVector(f32* v, int n);
	// p[^m,ôQz
	s32		Binomial(s32 n, f32 p);
	// ֌Wq̂QϗʐKz
	void	Binomial(s32 r, f32* x, f32* y);
	// p[^`,ãx[^z
	f32		Beta(f32 a, f32 b);
	// p[^m̗ݏ敪z
	f32		Power(f32 n);
	// WXeBbNz
	f32		Logistic(void);
	// R[V[z
	f32		Cauchy(void);
	// Rx`,âez
	f32		FDist(f32 a, f32 b);
	// σɂ̃|A\z
	s32		Poisson(f32 lambda);
	// Rxm̂z
	f32		TDist(f32 n);
	// p[^̃Cuz
	f32		Weibull(f32 alpha);
};

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

#endif
