//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndLCG.cpp
 * @brief		`@ɂ闐WFl[^t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndLCG_CPP_

//======================================================================
// include
#include "RndLCG.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// define
#if 0
// Œgp
#define FIRST_SEED		(1)				// l
#define RNDLCGS_MUL		(16807)			// 搔
#define RNDLCGS_BIAS	(1)				// oCAX
#define RNDLCGS_AND		(2147483647)	// @i&Zj
//#define RNDLCGS_MOD		(2147483647)	// @i%Zj
#else
// Knuth搶nt
#define FIRST_SEED		(1)				// l
#define RNDLCGS_MUL		(1664525)		// 搔
#define RNDLCGS_BIAS	(1013904223)	// oCAX
//#define RNDLCGS_AND		(0x100000000)	// @i&Zj
//#define RNDLCGS_MOD		(0x100000000)	// @i%Zj
#endif

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CLCGRand::CLCGRand(void)
{
	SetSeed(FIRST_SEED);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CLCGRand::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	m_v = seed;
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CLCGRand::GenRand32(void)
{
	m_v = m_v*RNDLCGS_MUL + RNDLCGS_BIAS;
#if		defined(RNDLCGS_MOD)
	m_v %= RNDLCGS_MOD;
#elif	defined(RNDLCGS_AND)
	m_v &= RNDLCGS_MOD;
#endif
	return m_v;
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris
