//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndXOR.cpp
 * @brief		RndXOR t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndXOR_CPP_

//======================================================================
// include
#include "RndXOR.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CXorShift::CXorShift(void)
{
	SetSeed(88675123);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CXorShift::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	m_v4 = seed;
	m_v3 = 1812433253 * ((m_v4 ^ (m_v4>>30)) + 1);
	m_v2 = 1812433253 * ((m_v3 ^ (m_v3>>30)) + 2);
	m_v1 = 1812433253 * ((m_v2 ^ (m_v2>>30)) + 3);
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CXorShift::GenRand32(void)
{
	u32 t = (m_v1 ^ (m_v1<<11));
	m_v1 = m_v2;
	m_v2 = m_v3;
	m_v3 = m_v4;
	m_v4 = (m_v4 ^ (m_v4>>19)) ^ (t ^ (t>>8));
	return m_v4;
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris
