//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathTScalar.h
 * @brief		XJ[lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathTScalar_H_
#define INCG_IRIS_MathTScalar_H_

//======================================================================
// include
#include "MathTFpu.h"

namespace iris {
namespace math
{

//======================================================================
// declare
template<typename _TN>_TN	TFpuScalarAbs(_TN fs);
template<typename _TN>_TN	TFpuScalarAcos(_TN fs);
template<typename _TN>_TN	TFpuScalarAsin(_TN fs);
template<typename _TN>_TN	TFpuScalarAtan(_TN fs);
template<typename _TN>_TN	TFpuScalarAtan2(_TN y, _TN x);
template<typename _TN>_TN	TFpuScalarCeil(_TN fs);
template<typename _TN>_TN	TFpuScalarCos(_TN fs);
template<typename _TN>_TN	TFpuScalarExp(_TN fs);
template<typename _TN>_TN	TFpuScalarFloor(_TN fs);
template<typename _TN>_TN	TFpuScalarLog(_TN fs);
template<typename _TN>_TN	TFpuScalarLog2(_TN fs);
template<typename _TN>_TN	TFpuScalarLog10(_TN fs);
template<typename _TN>_TN	TFpuScalarMax(_TN a, _TN b);
template<typename _TN>_TN	TFpuScalarMin(_TN a, _TN b);
template<typename _TN>_TN	TFpuScalarPow(_TN x, _TN y);
template<typename _TN>_TN	TFpuScalarPow2(_TN fs);
template<typename _TN>_TN	TFpuScalarRound(_TN fs);
template<typename _TN>_TN	TFpuScalarRsqrt(_TN fs);
template<typename _TN>_TN	TFpuScalarSin(_TN fs);
template<typename _TN>_TN	TFpuScalarSqrt(_TN fs);
template<typename _TN>_TN	TFpuScalarTan(_TN fs);
template<typename _TN>_TN	TFpuScalarTrunc(_TN fs);

//======================================================================
// function
/**
 * @brief	_̐ΒlԂ
 * @param [in]	fs	= l
 * @return	Βl
*/
template<typename _TN>_TN	TFpuScalarAbs(_TN fs)
{
	return fs < 0 ? -fs : fs;
}

/**
 * @brief	t](A[NRTC)vZ
 * @param [in]	fs	= l
 * @return	t]
*/
template<typename _TN>_TN	TFpuScalarAcos(_TN fs)
{
	return acos(fs);
}

/**
 * @brief	t(A[NTC)vZ
 * @param [in]	fs	= l
 * @return	t
*/
template<typename _TN>_TN	TFpuScalarAsin(_TN fs)
{
	return asin(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	fs	= l
 * @return	t
*/
template<typename _TN>_TN	TFpuScalarAtan(_TN fs)
{
	return atan(fs);
}

/**
 * @brief	t(A[N^WFg)vZ
 * @param [in]	y	= yl
 * @param [in]	x	= xl
 * @return	t
*/
template<typename _TN>_TN	TFpuScalarAtan2(_TN y, _TN x)
{
	return atan2(y, x);
}

/**
 * @brief	XJ[l̐؂グ
 * @param [in]	fs	= l
 * @return	؂グl
*/
template<typename _TN>_TN	TFpuScalarCeil(_TN fs)
{
	return ceil(fs);
}

/**
 * @brief	](RTC)vZ
 * @param [in]	fs	= WAl
 * @return	]
*/
template<typename _TN>_TN	TFpuScalarCos(_TN fs)
{
	return cos(fs);
}

/**
 * @brief	eƂw
 * @param [in]	fs	= l
 * @return	eƂw
*/
template<typename _TN>_TN	TFpuScalarExp(_TN fs)
{
	return exp(fs);
}

/**
 * @brief	XJ[l̐؂̂
 * @param [in]	fs	= l
 * @return	؂̂Ăl
*/
template<typename _TN>_TN	TFpuScalarFloor(_TN fs)
{
	return floor(fs);
}

/**
 * @brief	Rΐ
 * @param [in]	fs	= l
 * @return	Rΐ
*/
template<typename _TN>_TN	TFpuScalarLog(_TN fs)
{
	return log(fs);
}

/**
 * @brief	2Ƃΐ
 * @param [in]	fs	= l
 * @return	2Ƃΐ
*/
template<typename _TN>_TN	TFpuScalarLog2(_TN fs)
{
	return log2(fs);
}

/**
 * @brief	pΐ
 * @param [in]	fs	= l
 * @return	pΐ
*/
template<typename _TN>_TN	TFpuScalarLog10(_TN fs)
{
	return log10(fs);
}

/**
 * @brief	XJ[ől
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ől
*/
template<typename _TN>_TN	TFpuScalarMax(_TN a, _TN b)
{
	return (a > b) ? a : b;
}

/**
 * @brief	XJ[ŏl
 * @param [in]	a	= l
 * @param [in]	b	= l
 * @return	ŏl
*/
template<typename _TN>_TN	TFpuScalarMin(_TN a, _TN b)
{
	return (a < b) ? a : b;
}

/**
 * @brief	w
 * @param [in]	x	= l
 * @param [in]	y	= l
 * @return	w
*/
template<typename _TN>_TN	TFpuScalarPow(_TN x, _TN y)
{
	return pow(x, y);
}

/**
 * @brief	2Ƃw
 * @param [in]	fs	= l
 * @return	w
*/
template<typename _TN>_TN	TFpuScalarPow2(_TN fs)
{
	return pow2(fs);
}

/**
 * @brief	ߖTۂ(ľܓ)
 * @param [in]	fs	= l
 * @return	ۂ߂l
*/
template<typename _TN>_TN	TFpuScalarRound(_TN fs)
{
	return (_TN)((int)(fs + cpp0x::one_traits<_TN>::value / 2));
}

/**
 * @brief	̋t
 * @param [in]	fs	= l
 * @return	̋t
*/
template<typename _TN>_TN	TFpuScalarRsqrt(_TN fs)
{
	return rsqrt(fs);
}

/**
 * @brief	(TC)
 * @param [in]	fs	= WAl
 * @return	
*/
template<typename _TN>_TN	TFpuScalarSin(_TN fs)
{
	return sin(fs);
}

/**
 * @brief	
 * @param [in]	fs	= l
 * @return	
*/
template<typename _TN>_TN	TFpuScalarSqrt(_TN fs)
{
	return sqrt(fs);
}

/**
 * @brief	(^WFg)
 * @param [in]	fs	= WAl
 * @return	
*/
template<typename _TN>_TN	TFpuScalarTan(_TN fs)
{
	return tan(fs);
}

/**
 * @brief	0ۂ
 * @param [in]	fs	= l
 * @return	ۂ߂l
*/
template<typename _TN>_TN	TFpuScalarTrunc(_TN fs)
{
	return (_TN)((int)(fs));
}

}	// end of namespace math
}	// end of namespace iris

#endif
