//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_align.h
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_align_H_
#define INCG_IRIS_iris_align_H_

//======================================================================
// include
#include "../iris_inchead.h"

#if		defined(_WIN32)
#ifndef IRIS_DECLSPEC_ALIGN
#if	IRIS_MSC_AT_LEAST(1300) && !defined(MIDL_PASS)
#define IRIS_DECLSPEC_ALIGN(x)	__declspec(align(x))
#else
#define IRIS_DECLSPEC_ALIGN(x)
#endif
#endif

#ifndef IRIS_ATTRIBUTE_ALIGN
#define IRIS_ATTRIBUTE_ALIGN(x)
#endif

#ifndef IRIS_ATTRIBUTE_PACKED
#define IRIS_ATTRIBUTE_PACKED
#endif

#elif	defined(IRIS_GNUC)

#ifndef IRIS_DECLSPEC_ALIGN
#define IRIS_DECLSPEC_ALIGN(x)
#endif

#ifndef IRIS_ATTRIBUTE_ALIGN
#define IRIS_ATTRIBUTE_ALIGN(x)		__attribute__((aligned(x)))
#endif

#ifndef IRIS_ATTRIBUTE_PACKED
#define IRIS_ATTRIBUTE_PACKED		__attribute__((packed))
#endif

#endif

#ifndef	IRIS_DECLSPEC_ALIGN
#define IRIS_DECLSPEC_ALIGN(x)
#endif

#ifndef IRIS_ATTRIBUTE_ALIGN
#define IRIS_ATTRIBUTE_ALIGN(x)
#endif

#ifndef IRIS_ATTRIBUTE_PACKED
#define IRIS_ATTRIBUTE_PACKED
#endif

#endif
