//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_padding.hpp
 * @brief		PADDING }p t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_padding_HPP_
#define INCG_IRIS_iml_padding_HPP_

//======================================================================
// include
#include "../iris_stdint.h"

namespace iml
{

//======================================================================
// class
/// pfBO}NX
template<intmax_t SIZE, intmax_t ALIGN=4>
class padding
{
	template<intmax_t N, intmax_t A>
	struct padding_impl
	{
		static const int byte_size = (A - (N%A));
		static const int bit_size = byte_size * 8;
	};
	template<intmax_t N>
	struct padding_impl<N, 1>
	{
		static const int byte_size = 0;
		static const int bit_size = 0;
	};

public:
	static const int size = padding_impl<SIZE, ALIGN>::bit_size;
};

}	// end of namespace

#endif
