//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_bits.h
 * @brief		iml_bits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_bits_H_
#define INCG_IRIS_iml_bits_H_

//======================================================================
// include
#include "iml_mask.hpp"
#include "../iml_type_info.hpp"

namespace iml
{

/**
 * @brief	MSB0Zo
 *			Count Leading Zero
 * @tparam	TN	= ^
 * @tparam	V	= l
*/
template<typename TN, TN V>
class static_clz
{
	template<TN TV, intmax_t IDX, bool BIT>
	struct clz_impl
	{
		static const intmax_t	value = 1 + clz_impl<TV, IDX-1, (TV & static_mask<1, IDX-1>::value) == 0 >::value;
	};

	template<TN TV, bool BIT>
	struct clz_impl<TV, 0, BIT>
	{
		static const intmax_t	value = BIT ? 1 : 0;
	};

	template<TN TV, intmax_t IDX>
	struct clz_impl<TV, IDX, false>
	{
		static const intmax_t	value = 0;
	};

	template<TN TV, intmax_t IDX>
	struct clz_impl_1st
	{
		static const intmax_t	value	= clz_impl<TV, IDX-1, (TV & static_mask<1, IDX-1>::value) == 0 >::value;
	};

public:
	static const intmax_t	value = clz_impl_1st< V, type_info<TN>::bits >::value;
};

/**
 * @brief	MSB1Zo
 *			Count Leading One
 * @tparam	TN	= ^
 * @tparam	V	= l
*/
template<typename TN, TN V>
class static_clo
{
public:
	static const intmax_t	value = static_clz<TN, ~V>::value;
};

/**
 * @brief	LSB0Zo
 *			Count Trailing Zero
 * @tparam	TN	= ^
 * @tparam	V	= l
*/
template<typename TN, TN V>
class static_ctz
{
	template<TN TV, intmax_t IDX, bool BIT>
	struct ctz_impl
	{
		static const intmax_t	value = 1 + ctz_impl<TV, IDX-1, (TV & static_mask<1, (type_info<TN>::bits - IDX)>::value) == 0 >::value;
	};

	template<TN TV, bool BIT>
	struct ctz_impl<TV, 0, BIT>
	{
		static const intmax_t	value = BIT ? 1 : 0;
	};

	template<TN TV, intmax_t IDX>
	struct ctz_impl<TV, IDX, false>
	{
		static const intmax_t	value = 0;
	};

	template<TN TV>
	struct ctz_impl_1st
	{
		static const intmax_t	value	= ctz_impl<TV, type_info<TN>::bits, (TV & static_mask<1, 0>::value) == 0 >::value;
	};

public:
	static const intmax_t	value = ctz_impl_1st<V>::value;
};

/**
 * @brief	LSB1Zo
 *			Count Trailing One
 * @tparam	TN	= ^
 * @tparam	V	= l
*/
template<typename TN, TN V>
class static_cto
{
public:
	static const intmax_t	value = static_ctz<TN, ~V>::value;
};

}	// end of namespace iris

#endif
