//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_log2.hpp
 * @brief		iris meta language log2 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_log2_HPP_
#define INCG_IRIS_iml_log2_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"
#include "iml_pow.hpp"
#include "../../iris_debug.h"

namespace iml
{

//======================================================================
// class
/**
 * @brief	log2
*/
template<intmax_t V>
class static_log2
{
	IRIS_STATIC_ASSERT( static_is_pow2<V>::value );

	template<intmax_t VT, typename DMY_>
	struct log2_impl
	{
		static const intmax_t value = 1 + log2_impl< (VT>>1), DMY_ >::value;
	};

	template<typename DMY_>
	struct log2_impl<1, DMY_>
	{
		static const intmax_t value = 0;
	};

public:
	static const intmax_t value = log2_impl<V, void>::value;
};

}	// end of namespace iml

#endif
