//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_mask.hpp
 * @brief		iris meta language mask t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_mask_HPP_
#define INCG_IRIS_iml_mask_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"
#include "../iml_constant.hpp"

namespace iml
{

//======================================================================
// class
/**
 * @brief	}XNl
*/
template<intmax_t BITS, intmax_t SHIFT=0>
class static_mask
	: public constant<uintmax_t, (((uintmax_t)1<<BITS)-1) << SHIFT>
{
};

}	// end of namespace iml

#endif
