//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_shift.hpp
 * @brief		iris meta language shift t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_shift_HPP_
#define INCG_IRIS_iml_shift_HPP_

//======================================================================
// include
#include "iml_abs.hpp"
#include "iml_sign.hpp"

namespace iml
{

//======================================================================
// class
/**
 * @brief	tVtg萔
*/
template<intmax_t V, intmax_t S>
class static_lshift
{
	template<intmax_t TV, intmax_t TS, intmax_t SIGN>
	struct shift_impl
	{
		static const intmax_t value = TV << TS;
	};
	template<intmax_t TV, intmax_t TS>
	struct shift_impl<TV, TS, -1>
	{
		static const intmax_t value = TV >> static_abs<TS>::value;
	};
public:
	static const intmax_t value = shift_impl<V, S, static_sign<S>::value>::value;
};

/**
 * @brief	tEVtg萔
*/
template<intmax_t V, intmax_t S>
class static_rshift
{
	template<intmax_t TV, intmax_t TS, intmax_t SIGN>
	struct shift_impl
	{
		static const intmax_t value = TV >> TS;
	};
	template<intmax_t TV, intmax_t TS>
	struct shift_impl<TV, TS, -1>
	{
		static const intmax_t value = TV << static_abs<TS>::value;
	};
public:
	static const intmax_t value = shift_impl<V, S, static_sign<S>::value>::value;
};

/**
 * @brief	tVtg
*/
template<intmax_t SHIFT>
class signed_lshift
{
	template<typename TN, intmax_t TS, intmax_t SIGN>
	struct shift_impl
	{
		static TN	shift(TN v)	{ return v << TS; }
	};
	template<typename TN, intmax_t TS>
	struct shift_impl<TN, TS, -1>
	{
		// warning C4333: '>>' : EVtg̉񐔂܂Bf[^\܂
		// ւ̑Ή
		template<bool b, intmax_t TTS>
		struct impl
		{
			static TN	shift(TN v)	{ return v >> TTS; }
		};
		template<intmax_t TTS>
		struct impl<true, TTS>
		{
			static TN	shift(TN /*v*/)	{ return 0; }
		};

		static TN	shift(TN v)
		{ 
			return impl< ((sizeof(TN)*8) <= (-TS)), -TS >::shift(v);
		}
	};
public:
	template<typename TN>
	static TN	shift(TN v) { return shift_impl<TN, SHIFT, static_sign<SHIFT>::value>::shift(v); }
};

/**
 * @brief	tEVtg
*/
template<intmax_t SHIFT_>
class signed_rshift
{
	template<typename TN, intmax_t TS, intmax_t SIGN>
	struct shift_impl
	{
		// warning C4333: '>>' : EVtg̉񐔂܂Bf[^\܂
		// ւ̑Ή
		template<bool b, intmax_t TTS>
		struct impl
		{
			static TN	shift(TN v)	{ return v >> TTS; }
		};
		template<intmax_t TTS>
		struct impl<true, TTS>
		{
			static TN	shift(TN /*v*/)	{ return 0; }
		};

		static TN	shift(TN v)
		{ 
			return impl< ((sizeof(TN)*8) <= TS), TS >::shift(v);
		}
	};
	template<typename TN, intmax_t TS>
	struct shift_impl<TN, TS, -1>
	{
		static TN	shift(TN v)	{ return v << static_abs<TS>::value; }
	};
public:
	template<typename TN_>
	static TN_	shift(TN_ v) { return shift_impl<TN_, SHIFT_, static_sign<SHIFT_>::value>::shift(v); }
};

}	// end of namespace iml

#endif
