//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkMemory.cpp
 * @brief		Havok AP[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkMemory_CPP_

//======================================================================
// include
#include "HvkMemory.h"

#ifdef _IRIS_SUPPORT_HAVOK

#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>

//======================================================================
// link
#pragma comment	(lib, "hkBase.lib")

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMemoryRouter::CMemoryRouter(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMemoryRouter::CMemoryRouter(hkMemoryAllocator* memoryAllocator, const hkMemorySystem::FrameInfo& info)
{
	Create(memoryAllocator, info);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMemoryRouter::~CMemoryRouter(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMemoryRouter::Create(void)
{
	if( is_valid() ) return true;
#if HAVOKVER_AT_LEAST(2010, 0)
	m_object = hkMemoryInitUtil::initDefault(hkMallocAllocator::m_defaultMallocAllocator, hkMemorySystem::FrameInfo( 500*1024 ));
#else
	m_object = hkMemoryInitUtil::initDefault();
#endif
	return true;
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMemoryRouter::Create(hkMemoryAllocator* memoryAllocator, const hkMemorySystem::FrameInfo& info)
{
	if( is_valid() ) return true;
#if HAVOKVER_AT_LEAST(2010, 0)
	m_object = hkMemoryInitUtil::initDefault(memoryAllocator, info);
#else
	IRIS_UNUSED_VAR(memoryAllocator);
	IRIS_UNUSED_VAR(info);
	m_object = hkMemoryInitUtil::initDefault();
#endif
	return true;
}

/**********************************************************************//**
 *
 * 폜
 *
*//***********************************************************************/
void CMemoryRouter::Delete(void)
{
	m_object = nullptr;
}

}	// end of namespace havok
}	// end of namespace iris

#endif
