//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkMemory.h
 * @brief		Havok AP[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkMemory_H_
#define INCG_IRIS_HvkMemory_H_

//======================================================================
// include
#include "hvk_inchead.h"
#include "../../fnd/container/FndWrapObject.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>

namespace iris {
namespace havok
{

//======================================================================
// class
/**
 * @ingroup	Havok
 * @brief	[^[NX
*/
class CMemoryRouter : public fnd::CWrapObject<hkMemoryRouter*>
{
public:
	// RXgN^
	CMemoryRouter(void);
	CMemoryRouter(hkMemoryAllocator* memoryAllocator, const hkMemorySystem::FrameInfo& info);
	// fXgN^
	~CMemoryRouter(void);

public:
	// 쐬
	bool	Create(void);
	bool	Create(hkMemoryAllocator* memoryAllocator, const hkMemorySystem::FrameInfo& info);
	// 폜
	void	Delete(void);
};

}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
