//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkSystem.cpp
 * @brief		Havok AP[^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkSystem_CPP_

//======================================================================
// include
#include "HvkSystem.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_HAVOK

#include <Common/Base/keycode.cxx>
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>

//======================================================================
// link
#pragma comment	(lib, "hkBase.lib")

namespace iris {
namespace havok
{

//======================================================================
// declare
void _hvkErrorReportFunction(const char* s, void* errorReportObject);

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHavokSystem::CHavokSystem(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHavokSystem::~CHavokSystem(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CHavokSystem::Initialize(void)
{
#if HAVOKVER_AT_LEAST(2010, 0)
	return Initialize(hkMallocAllocator::m_defaultMallocAllocator, hkMemorySystem::FrameInfo( 500*1024 ));
#else
	if( m_Router.is_valid() ) return true;
	if( !m_Router.Create() ) return false;
	hkBaseSystem::init(m_Router, _hvkErrorReportFunction);
	return true;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CHavokSystem::Initialize(hkMemoryAllocator* memoryAllocator, const hkMemorySystem::FrameInfo& info)
{
	if( m_Router.is_valid() ) return true;
	if( !m_Router.Create(memoryAllocator, info) ) return false;
	hkBaseSystem::init(m_Router, _hvkErrorReportFunction);
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CHavokSystem::Terminate(void)
{
	hkBaseSystem::quit();
	hkMemoryInitUtil::quit();
	m_Router.Delete();
}

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * G[|[gR[obN
 *
*//***********************************************************************/
void _hvkErrorReportFunction(const char* s, void* errorReportObject)
{
	IRIS_WARNING(s);
}



}	// end of namespace havok
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "iris_using.h"
#include <stdio.h>

//======================================================================
// declare
UNITTEST_MAIN_FUNC(HvkSystemUnitTest);

//======================================================================
// class
class CHvkSystemUnitTest : public iris::unit::CUnitTest<CHvkSystemUnitTest> {};

// `
IRIS_UNITTEST(CHvkSystemUnitTest, Func);

//======================================================================
// typedef
typedef CHvkSystemUnitTest	dbUnitTest;

/**********************************************************************//**
 *
 * UNITTEST_MAIN
 *
 ----------------------------------------------------------------------
 * @return
*//***********************************************************************/
UNITTEST_MAIN_FUNC(HvkSystemUnitTest)
{
	CHavokSystem system;
	system.Initialize();
	return 0;
}

#endif

#endif
