//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkTriangleShape.cpp
 * @brief		Havok TriangleShape t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkTriangleShape_CPP_

//======================================================================
// include
#include "HvkTriangleShape.h"


#ifdef _IRIS_SUPPORT_HAVOK

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CTriangleShape::CTriangleShape(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CTriangleShape::~CTriangleShape(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	radius		= a
 * @param [in]	weldingInfo	= 
 * @param [in]	type		= ^Cv
 * @retrun	
*//***********************************************************************/
bool CTriangleShape::Create(hkReal radius, hkUint16 weldingInfo, hkpWeldingUtility::WeldingType type)
{
	Delete();
	m_ptr = new hkpTriangleShape(radius, weldingInfo, type);
	if( m_ptr == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	v0		= _0
 * @param [in]	v1		= _1
 * @param [in]	v2		= _2
 * @param [in]	radius	= a
 * @retrun	
*//***********************************************************************/
bool CTriangleShape::Create(const hkVector4& v0, const hkVector4& v1, const hkVector4& v2, hkReal radius )
{
	Delete();
	m_ptr = new hkpTriangleShape(v0, v1, v2, radius);
	if( m_ptr == nullptr ) return false;
	return true;
}

}	// end of namespace havok
}	// end of namespace iris

#endif
