//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		stm32_bootloader_win.cpp
 * @brief		stm32_bootloader_win t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_stm32_bootloader_win_C_

//======================================================================
// include
#include "../STMBootloader.h"

#ifdef _WIN32
#include <windows.h>

// M֐
int stm32_bootloader_write(STM32PORT port, const void* buf, int size)
{
	DWORD written = 0;
	if( !WriteFile(port, buf, size, &written, NULL) ) return FALSE;
	if( written == 0 ) return FALSE;
	return TRUE;
}
// M֐
int stm32_bootloader_read(STM32PORT port, void* buf, int size)
{
	DWORD read = 0;
	while(1)
	{
		if( !ReadFile(port, buf, size, &read, NULL) ) return FALSE;
		if( read != 0 ) break;
		Sleep(10);
	}
	return TRUE;
}
// u[No
int stm32_bootloader_break(STM32PORT port)
{
	return SetCommBreak(port);
}

#endif
