//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_platform_using.h
 * @brief		irisvbgtH[usingwb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_platform_using_H_
#define INCG_IRIS_iris_platform_using_H_

//======================================================================
// include
#if	defined(_IRIS_SUPPORT_EXT_PLATFORM)
#  include "iris_ext_using.h"
#endif

//======================================================================
// namespace
#if defined(__cplusplus)
namespace iris
{
// vbgtH[Ƃusing
#if		defined(IRIS_WIN32)	// for windows

	//! DirectX
	namespace dx
	{
		//! intr
		namespace intr {}
		//! flag
		namespace flag {}

		using namespace intr;
	}
	//! Windows
	namespace wx
	{
		//! Win dbg
		namespace dbg {}
	}
	using namespace dx;
	using namespace wx;

#if		defined(IRIS_WIN32_WCE)
	namespace ce {}
	using namespace ce;
#endif
#if		defined(_IRIS_SUPPORT_MFC)
	namespace mfc {}
	using namespace mfc;
#endif

#elif	defined(IRIS_IPHONE)	// for iPhone
	namespace ipx {}
	using namespace ipx;
#elif	defined(IRIS_MAC)	// for mac
	namespace mac {}
	using namespace mac;
#elif	defined(IRIS_NACL)	// for Native Client
	namespace nacl {}
	using namespace nacl;
#else

#endif


}	// end of namespace iris
#endif

#endif
