//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceMenu.cpp
 * @brief		WceMenu t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceMenu_CPP_

//======================================================================
// include
#include "WceMenu.h"

#if	defined(IRIS_WIN32_WCE)
#include <aygshell.h>

namespace iris {
namespace wx {
namespace ce
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMenu::CMenu(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CMenu::CMenu(HWND hWnd)
: CWindow(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMenu::~CMenu(void)
{
}

/**********************************************************************//**
 *
 * j[쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszClassName	= NX
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CMenu::Create(LPCTSTR lpszClassName
					 , LPCTSTR lpszWindowName, DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam )
{
	SHMENUBARINFO mbi;
	mbi.cbSize = sizeof(mbi);
	mbi.hwndParent = hWndParent;
	mbi.dwFlags = dwStyle;
	mbi.hInstRes = hInstance;
	mbi.nToolBarId = nID;
	if( !SHCreateMenuBar(&mbi) ) return nullptr;
	HWND hMenu = SHFindMenuBar(hWndParent);
	if( hMenu != nullptr )
	{
		if( !Attach(hMenu) )
		{
			::DestroyWindow(hMenu);
			return nullptr;
		}
	}
	return hMenu;
}

}	// end of namespace ce
}	// end of namespace wx
}	// end of namespace iris


#endif
