//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapGdi.h
 * @brief		GDI֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceWrapGdi_CPP_

//======================================================================
// include
#include "WceWrapGdi.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * CreateFontA, W
 *
 -----------------------------------------------------------------------
 * @param [in]	height			= tHg
 * @param [in]	width			= 
 * @param [in]	escapement		= eLXg̊px	
 * @param [in]	orientation		= x[XCƂƂ̊px
 * @param [in]	weight			= tHg̏dij
 * @param [in]	bItalic			= C^bN
 * @param [in]	bUnderline		= A_[C
 * @param [in]	bStrikeOut		= ł
 * @param [in]	iCharSet		= Zbg
 * @param [in]	iOutPrecision	= o͐x
 * @param [in]	iClipPrecision	= NbsOx
 * @param [in]	iQuality		= o͕i
 * @param [in]	iPitchAndFamily	= sb`ƃt@~[
 * @param [in]	pszFaceName		= ̖
 * @return	tHgnh
*//***********************************************************************/
WINGDIAPI HFONT	WINAPI CreateFontA(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, DWORD bItalic
								   , DWORD bUnderline, DWORD bStrikeOut, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
								   , DWORD iQuality, DWORD iPitchAndFamily, LPCSTR pszFaceName)
{
#if 1
	return nullptr;
#else
	LOGFONTA lf;
	lf.lfCharSet		= (BYTE)iCharSet;
	lf.lfClipPrecision	= (BYTE)iClipPrecision;
	lf.lfEscapement		= nEscapement;
	lf.lfHeight			= nHeight;
	lf.lfItalic			= (BYTE)bItalic;
	lf.lfOrientation	= nOrientation;
	lf.lfOutPrecision	= (BYTE)iOutPrecision;
	lf.lfPitchAndFamily	= (BYTE)iPitchAndFamily;
	lf.lfQuality		= (BYTE)iQuality;
	lf.lfStrikeOut		= (BYTE)bStrikeOut;
	lf.lfUnderline		= (BYTE)bUnderline;
	lf.lfWeight			= nWeight;
	lf.lfWidth			= nWidth;
	strcpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateFontIndirectA(&lf);
#endif
}
WINGDIAPI HFONT	WINAPI CreateFontW(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, DWORD bItalic
									 , DWORD bUnderline, DWORD bStrikeOut, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
									 , DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName)
{
	LOGFONTW lf;
	lf.lfCharSet		= (BYTE)iCharSet;
	lf.lfClipPrecision	= (BYTE)iClipPrecision;
	lf.lfEscapement		= nEscapement;
	lf.lfHeight			= nHeight;
	lf.lfItalic			= (BYTE)bItalic;
	lf.lfOrientation	= nOrientation;
	lf.lfOutPrecision	= (BYTE)iOutPrecision;
	lf.lfPitchAndFamily	= (BYTE)iPitchAndFamily;
	lf.lfQuality		= (BYTE)iQuality;
	lf.lfStrikeOut		= (BYTE)bStrikeOut;
	lf.lfUnderline		= (BYTE)bUnderline;
	lf.lfWeight			= nWeight;
	lf.lfWidth			= nWidth;
	wcscpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateFontIndirectW(&lf);
}

/**********************************************************************//**
 * @internal
 *
 * ExtCreatePen
 *
 -----------------------------------------------------------------------
 * @param [in]	iPenStyle	= yX^C
 * @param [in]	cWidth		= 
 * @param [in]	plbrush		= uV
 * @param [in]	cStyle		= JX^X^Cz̃TCY
 * @param [in]	pstyle		= JX^X^Cz
 * @return	yIuWFNg
*//***********************************************************************/
WINGDIAPI HPEN	WINAPI	ExtCreatePen(DWORD iPenStyle, DWORD cWidth, CONST LOGBRUSH *plbrush, DWORD cStyle, CONST DWORD *pstyle)
{
	if( plbrush == nullptr ) return nullptr;
	return ::CreatePen(iPenStyle, cWidth, plbrush->lbColor);
}

#endif
